/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The choice level improvement plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChoiceImprovementPlan implements SdkPojo, Serializable,
        ToCopyableBuilder<ChoiceImprovementPlan.Builder, ChoiceImprovementPlan> {
    private static final SdkField<String> CHOICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChoiceId").getter(getter(ChoiceImprovementPlan::choiceId)).setter(setter(Builder::choiceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChoiceId").build()).build();

    private static final SdkField<String> DISPLAY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayText").getter(getter(ChoiceImprovementPlan::displayText)).setter(setter(Builder::displayText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayText").build()).build();

    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImprovementPlanUrl").getter(getter(ChoiceImprovementPlan::improvementPlanUrl))
            .setter(setter(Builder::improvementPlanUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHOICE_ID_FIELD,
            DISPLAY_TEXT_FIELD, IMPROVEMENT_PLAN_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String choiceId;

    private final String displayText;

    private final String improvementPlanUrl;

    private ChoiceImprovementPlan(BuilderImpl builder) {
        this.choiceId = builder.choiceId;
        this.displayText = builder.displayText;
        this.improvementPlanUrl = builder.improvementPlanUrl;
    }

    /**
     * Returns the value of the ChoiceId property for this object.
     * 
     * @return The value of the ChoiceId property for this object.
     */
    public final String choiceId() {
        return choiceId;
    }

    /**
     * <p>
     * The display text for the improvement plan.
     * </p>
     * 
     * @return The display text for the improvement plan.
     */
    public final String displayText() {
        return displayText;
    }

    /**
     * Returns the value of the ImprovementPlanUrl property for this object.
     * 
     * @return The value of the ImprovementPlanUrl property for this object.
     */
    public final String improvementPlanUrl() {
        return improvementPlanUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(choiceId());
        hashCode = 31 * hashCode + Objects.hashCode(displayText());
        hashCode = 31 * hashCode + Objects.hashCode(improvementPlanUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChoiceImprovementPlan)) {
            return false;
        }
        ChoiceImprovementPlan other = (ChoiceImprovementPlan) obj;
        return Objects.equals(choiceId(), other.choiceId()) && Objects.equals(displayText(), other.displayText())
                && Objects.equals(improvementPlanUrl(), other.improvementPlanUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChoiceImprovementPlan").add("ChoiceId", choiceId()).add("DisplayText", displayText())
                .add("ImprovementPlanUrl", improvementPlanUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChoiceId":
            return Optional.ofNullable(clazz.cast(choiceId()));
        case "DisplayText":
            return Optional.ofNullable(clazz.cast(displayText()));
        case "ImprovementPlanUrl":
            return Optional.ofNullable(clazz.cast(improvementPlanUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChoiceImprovementPlan, T> g) {
        return obj -> g.apply((ChoiceImprovementPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChoiceImprovementPlan> {
        /**
         * Sets the value of the ChoiceId property for this object.
         *
         * @param choiceId
         *        The new value for the ChoiceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choiceId(String choiceId);

        /**
         * <p>
         * The display text for the improvement plan.
         * </p>
         * 
         * @param displayText
         *        The display text for the improvement plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayText(String displayText);

        /**
         * Sets the value of the ImprovementPlanUrl property for this object.
         *
         * @param improvementPlanUrl
         *        The new value for the ImprovementPlanUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder improvementPlanUrl(String improvementPlanUrl);
    }

    static final class BuilderImpl implements Builder {
        private String choiceId;

        private String displayText;

        private String improvementPlanUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ChoiceImprovementPlan model) {
            choiceId(model.choiceId);
            displayText(model.displayText);
            improvementPlanUrl(model.improvementPlanUrl);
        }

        public final String getChoiceId() {
            return choiceId;
        }

        public final void setChoiceId(String choiceId) {
            this.choiceId = choiceId;
        }

        @Override
        public final Builder choiceId(String choiceId) {
            this.choiceId = choiceId;
            return this;
        }

        public final String getDisplayText() {
            return displayText;
        }

        public final void setDisplayText(String displayText) {
            this.displayText = displayText;
        }

        @Override
        public final Builder displayText(String displayText) {
            this.displayText = displayText;
            return this;
        }

        public final String getImprovementPlanUrl() {
            return improvementPlanUrl;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        @Override
        public ChoiceImprovementPlan build() {
            return new ChoiceImprovementPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
