/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input for List Share Invitations
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListShareInvitationsRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<ListShareInvitationsRequest.Builder, ListShareInvitationsRequest> {
    private static final SdkField<String> WORKLOAD_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadNamePrefix").getter(getter(ListShareInvitationsRequest::workloadNamePrefix))
            .setter(setter(Builder::workloadNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WorkloadNamePrefix").build())
            .build();

    private static final SdkField<String> LENS_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LensNamePrefix").getter(getter(ListShareInvitationsRequest::lensNamePrefix))
            .setter(setter(Builder::lensNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensNamePrefix").build())
            .build();

    private static final SdkField<String> SHARE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareResourceType").getter(getter(ListShareInvitationsRequest::shareResourceTypeAsString))
            .setter(setter(Builder::shareResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ShareResourceType").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListShareInvitationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListShareInvitationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_PREFIX_FIELD,
            LENS_NAME_PREFIX_FIELD, SHARE_RESOURCE_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String workloadNamePrefix;

    private final String lensNamePrefix;

    private final String shareResourceType;

    private final String nextToken;

    private final Integer maxResults;

    private ListShareInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.workloadNamePrefix = builder.workloadNamePrefix;
        this.lensNamePrefix = builder.lensNamePrefix;
        this.shareResourceType = builder.shareResourceType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns the value of the WorkloadNamePrefix property for this object.
     * 
     * @return The value of the WorkloadNamePrefix property for this object.
     */
    public final String workloadNamePrefix() {
        return workloadNamePrefix;
    }

    /**
     * <p>
     * An optional string added to the beginning of each lens name returned in the results.
     * </p>
     * 
     * @return An optional string added to the beginning of each lens name returned in the results.
     */
    public final String lensNamePrefix() {
        return lensNamePrefix;
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The type of share invitations to be returned.
     * @see ShareResourceType
     */
    public final ShareResourceType shareResourceType() {
        return ShareResourceType.fromValue(shareResourceType);
    }

    /**
     * <p>
     * The type of share invitations to be returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareResourceType}
     * will return {@link ShareResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shareResourceTypeAsString}.
     * </p>
     * 
     * @return The type of share invitations to be returned.
     * @see ShareResourceType
     */
    public final String shareResourceTypeAsString() {
        return shareResourceType;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @return The maximum number of results to return for this request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(lensNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(shareResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShareInvitationsRequest)) {
            return false;
        }
        ListShareInvitationsRequest other = (ListShareInvitationsRequest) obj;
        return Objects.equals(workloadNamePrefix(), other.workloadNamePrefix())
                && Objects.equals(lensNamePrefix(), other.lensNamePrefix())
                && Objects.equals(shareResourceTypeAsString(), other.shareResourceTypeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListShareInvitationsRequest").add("WorkloadNamePrefix", workloadNamePrefix())
                .add("LensNamePrefix", lensNamePrefix()).add("ShareResourceType", shareResourceTypeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadNamePrefix":
            return Optional.ofNullable(clazz.cast(workloadNamePrefix()));
        case "LensNamePrefix":
            return Optional.ofNullable(clazz.cast(lensNamePrefix()));
        case "ShareResourceType":
            return Optional.ofNullable(clazz.cast(shareResourceTypeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShareInvitationsRequest, T> g) {
        return obj -> g.apply((ListShareInvitationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListShareInvitationsRequest> {
        /**
         * Sets the value of the WorkloadNamePrefix property for this object.
         *
         * @param workloadNamePrefix
         *        The new value for the WorkloadNamePrefix property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadNamePrefix(String workloadNamePrefix);

        /**
         * <p>
         * An optional string added to the beginning of each lens name returned in the results.
         * </p>
         * 
         * @param lensNamePrefix
         *        An optional string added to the beginning of each lens name returned in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensNamePrefix(String lensNamePrefix);

        /**
         * <p>
         * The type of share invitations to be returned.
         * </p>
         * 
         * @param shareResourceType
         *        The type of share invitations to be returned.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(String shareResourceType);

        /**
         * <p>
         * The type of share invitations to be returned.
         * </p>
         * 
         * @param shareResourceType
         *        The type of share invitations to be returned.
         * @see ShareResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareResourceType
         */
        Builder shareResourceType(ShareResourceType shareResourceType);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String workloadNamePrefix;

        private String lensNamePrefix;

        private String shareResourceType;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShareInvitationsRequest model) {
            super(model);
            workloadNamePrefix(model.workloadNamePrefix);
            lensNamePrefix(model.lensNamePrefix);
            shareResourceType(model.shareResourceType);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getWorkloadNamePrefix() {
            return workloadNamePrefix;
        }

        public final void setWorkloadNamePrefix(String workloadNamePrefix) {
            this.workloadNamePrefix = workloadNamePrefix;
        }

        @Override
        public final Builder workloadNamePrefix(String workloadNamePrefix) {
            this.workloadNamePrefix = workloadNamePrefix;
            return this;
        }

        public final String getLensNamePrefix() {
            return lensNamePrefix;
        }

        public final void setLensNamePrefix(String lensNamePrefix) {
            this.lensNamePrefix = lensNamePrefix;
        }

        @Override
        public final Builder lensNamePrefix(String lensNamePrefix) {
            this.lensNamePrefix = lensNamePrefix;
            return this;
        }

        public final String getShareResourceType() {
            return shareResourceType;
        }

        public final void setShareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
        }

        @Override
        public final Builder shareResourceType(String shareResourceType) {
            this.shareResourceType = shareResourceType;
            return this;
        }

        @Override
        public final Builder shareResourceType(ShareResourceType shareResourceType) {
            this.shareResourceType(shareResourceType == null ? null : shareResourceType.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShareInvitationsRequest build() {
            return new ListShareInvitationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
