/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A notification summary return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationSummary.Builder, NotificationSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(NotificationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<LensUpgradeSummary> LENS_UPGRADE_SUMMARY_FIELD = SdkField
            .<LensUpgradeSummary> builder(MarshallingType.SDK_POJO).memberName("LensUpgradeSummary")
            .getter(getter(NotificationSummary::lensUpgradeSummary)).setter(setter(Builder::lensUpgradeSummary))
            .constructor(LensUpgradeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensUpgradeSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            LENS_UPGRADE_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final LensUpgradeSummary lensUpgradeSummary;

    private NotificationSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.lensUpgradeSummary = builder.lensUpgradeSummary;
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notification.
     * @see NotificationType
     */
    public final NotificationType type() {
        return NotificationType.fromValue(type);
    }

    /**
     * <p>
     * The type of notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of notification.
     * @see NotificationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Summary of lens upgrade.
     * </p>
     * 
     * @return Summary of lens upgrade.
     */
    public final LensUpgradeSummary lensUpgradeSummary() {
        return lensUpgradeSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lensUpgradeSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSummary)) {
            return false;
        }
        NotificationSummary other = (NotificationSummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(lensUpgradeSummary(), other.lensUpgradeSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationSummary").add("Type", typeAsString())
                .add("LensUpgradeSummary", lensUpgradeSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "LensUpgradeSummary":
            return Optional.ofNullable(clazz.cast(lensUpgradeSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationSummary, T> g) {
        return obj -> g.apply((NotificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationSummary> {
        /**
         * <p>
         * The type of notification.
         * </p>
         * 
         * @param type
         *        The type of notification.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of notification.
         * </p>
         * 
         * @param type
         *        The type of notification.
         * @see NotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationType
         */
        Builder type(NotificationType type);

        /**
         * <p>
         * Summary of lens upgrade.
         * </p>
         * 
         * @param lensUpgradeSummary
         *        Summary of lens upgrade.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensUpgradeSummary(LensUpgradeSummary lensUpgradeSummary);

        /**
         * <p>
         * Summary of lens upgrade.
         * </p>
         * This is a convenience method that creates an instance of the {@link LensUpgradeSummary.Builder} avoiding the
         * need to create one manually via {@link LensUpgradeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LensUpgradeSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #lensUpgradeSummary(LensUpgradeSummary)}.
         * 
         * @param lensUpgradeSummary
         *        a consumer that will call methods on {@link LensUpgradeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lensUpgradeSummary(LensUpgradeSummary)
         */
        default Builder lensUpgradeSummary(Consumer<LensUpgradeSummary.Builder> lensUpgradeSummary) {
            return lensUpgradeSummary(LensUpgradeSummary.builder().applyMutation(lensUpgradeSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private LensUpgradeSummary lensUpgradeSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSummary model) {
            type(model.type);
            lensUpgradeSummary(model.lensUpgradeSummary);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final LensUpgradeSummary.Builder getLensUpgradeSummary() {
            return lensUpgradeSummary != null ? lensUpgradeSummary.toBuilder() : null;
        }

        public final void setLensUpgradeSummary(LensUpgradeSummary.BuilderImpl lensUpgradeSummary) {
            this.lensUpgradeSummary = lensUpgradeSummary != null ? lensUpgradeSummary.build() : null;
        }

        @Override
        public final Builder lensUpgradeSummary(LensUpgradeSummary lensUpgradeSummary) {
            this.lensUpgradeSummary = lensUpgradeSummary;
            return this;
        }

        @Override
        public NotificationSummary build() {
            return new NotificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
