/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReviewTemplateResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<UpdateReviewTemplateResponse.Builder, UpdateReviewTemplateResponse> {
    private static final SdkField<ReviewTemplate> REVIEW_TEMPLATE_FIELD = SdkField
            .<ReviewTemplate> builder(MarshallingType.SDK_POJO).memberName("ReviewTemplate")
            .getter(getter(UpdateReviewTemplateResponse::reviewTemplate)).setter(setter(Builder::reviewTemplate))
            .constructor(ReviewTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEW_TEMPLATE_FIELD));

    private final ReviewTemplate reviewTemplate;

    private UpdateReviewTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.reviewTemplate = builder.reviewTemplate;
    }

    /**
     * <p>
     * A review template.
     * </p>
     * 
     * @return A review template.
     */
    public final ReviewTemplate reviewTemplate() {
        return reviewTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reviewTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReviewTemplateResponse)) {
            return false;
        }
        UpdateReviewTemplateResponse other = (UpdateReviewTemplateResponse) obj;
        return Objects.equals(reviewTemplate(), other.reviewTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReviewTemplateResponse").add("ReviewTemplate", reviewTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReviewTemplate":
            return Optional.ofNullable(clazz.cast(reviewTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReviewTemplateResponse, T> g) {
        return obj -> g.apply((UpdateReviewTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateReviewTemplateResponse> {
        /**
         * <p>
         * A review template.
         * </p>
         * 
         * @param reviewTemplate
         *        A review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewTemplate(ReviewTemplate reviewTemplate);

        /**
         * <p>
         * A review template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReviewTemplate.Builder} avoiding the need
         * to create one manually via {@link ReviewTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReviewTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #reviewTemplate(ReviewTemplate)}.
         * 
         * @param reviewTemplate
         *        a consumer that will call methods on {@link ReviewTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewTemplate(ReviewTemplate)
         */
        default Builder reviewTemplate(Consumer<ReviewTemplate.Builder> reviewTemplate) {
            return reviewTemplate(ReviewTemplate.builder().applyMutation(reviewTemplate).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private ReviewTemplate reviewTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReviewTemplateResponse model) {
            super(model);
            reviewTemplate(model.reviewTemplate);
        }

        public final ReviewTemplate.Builder getReviewTemplate() {
            return reviewTemplate != null ? reviewTemplate.toBuilder() : null;
        }

        public final void setReviewTemplate(ReviewTemplate.BuilderImpl reviewTemplate) {
            this.reviewTemplate = reviewTemplate != null ? reviewTemplate.build() : null;
        }

        @Override
        public final Builder reviewTemplate(ReviewTemplate reviewTemplate) {
            this.reviewTemplate = reviewTemplate;
            return this;
        }

        @Override
        public UpdateReviewTemplateResponse build() {
            return new UpdateReviewTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
