/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A review template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReviewTemplate implements SdkPojo, Serializable, ToCopyableBuilder<ReviewTemplate.Builder, ReviewTemplate> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ReviewTemplate::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> LENSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Lenses")
            .getter(getter(ReviewTemplate::lenses))
            .setter(setter(Builder::lenses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(ReviewTemplate::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<Map<String, Integer>> QUESTION_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("QuestionCounts")
            .getter(getter(ReviewTemplate::questionCountsAsStrings))
            .setter(setter(Builder::questionCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(ReviewTemplate::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ReviewTemplate::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(ReviewTemplate::templateArn)).setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(ReviewTemplate::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ReviewTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(ReviewTemplate::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<String> SHARE_INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareInvitationId").getter(getter(ReviewTemplate::shareInvitationId))
            .setter(setter(Builder::shareInvitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            LENSES_FIELD, NOTES_FIELD, QUESTION_COUNTS_FIELD, OWNER_FIELD, UPDATED_AT_FIELD, TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, TAGS_FIELD, UPDATE_STATUS_FIELD, SHARE_INVITATION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final List<String> lenses;

    private final String notes;

    private final Map<String, Integer> questionCounts;

    private final String owner;

    private final Instant updatedAt;

    private final String templateArn;

    private final String templateName;

    private final Map<String, String> tags;

    private final String updateStatus;

    private final String shareInvitationId;

    private ReviewTemplate(BuilderImpl builder) {
        this.description = builder.description;
        this.lenses = builder.lenses;
        this.notes = builder.notes;
        this.questionCounts = builder.questionCounts;
        this.owner = builder.owner;
        this.updatedAt = builder.updatedAt;
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.tags = builder.tags;
        this.updateStatus = builder.updateStatus;
        this.shareInvitationId = builder.shareInvitationId;
    }

    /**
     * <p>
     * The review template description.
     * </p>
     * 
     * @return The review template description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Lenses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLenses() {
        return lenses != null && !(lenses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The lenses applied to the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLenses} method.
     * </p>
     * 
     * @return The lenses applied to the review template.
     */
    public final List<String> lenses() {
        return lenses;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * A count of how many total questions are answered and unanswered in the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestionCounts} method.
     * </p>
     * 
     * @return A count of how many total questions are answered and unanswered in the review template.
     */
    public final Map<Question, Integer> questionCounts() {
        return QuestionCountsCopier.copyStringToEnum(questionCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the QuestionCounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQuestionCounts() {
        return questionCounts != null && !(questionCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A count of how many total questions are answered and unanswered in the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQuestionCounts} method.
     * </p>
     * 
     * @return A count of how many total questions are answered and unanswered in the review template.
     */
    public final Map<String, Integer> questionCountsAsStrings() {
        return questionCounts;
    }

    /**
     * Returns the value of the Owner property for this object.
     * 
     * @return The value of the Owner property for this object.
     */
    public final String owner() {
        return owner;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The name of the review template.
     * </p>
     * 
     * @return The name of the review template.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the review template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The latest status of a review template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ReviewTemplateUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The latest status of a review template.
     * @see ReviewTemplateUpdateStatus
     */
    public final ReviewTemplateUpdateStatus updateStatus() {
        return ReviewTemplateUpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The latest status of a review template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link ReviewTemplateUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The latest status of a review template.
     * @see ReviewTemplateUpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The ID assigned to the template share invitation.
     * </p>
     * 
     * @return The ID assigned to the template share invitation.
     */
    public final String shareInvitationId() {
        return shareInvitationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasLenses() ? lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuestionCounts() ? questionCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareInvitationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplate)) {
            return false;
        }
        ReviewTemplate other = (ReviewTemplate) obj;
        return Objects.equals(description(), other.description()) && hasLenses() == other.hasLenses()
                && Objects.equals(lenses(), other.lenses()) && Objects.equals(notes(), other.notes())
                && hasQuestionCounts() == other.hasQuestionCounts()
                && Objects.equals(questionCountsAsStrings(), other.questionCountsAsStrings())
                && Objects.equals(owner(), other.owner()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(shareInvitationId(), other.shareInvitationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReviewTemplate").add("Description", description()).add("Lenses", hasLenses() ? lenses() : null)
                .add("Notes", notes()).add("QuestionCounts", hasQuestionCounts() ? questionCountsAsStrings() : null)
                .add("Owner", owner()).add("UpdatedAt", updatedAt()).add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("Tags", hasTags() ? tags() : null)
                .add("UpdateStatus", updateStatusAsString()).add("ShareInvitationId", shareInvitationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Lenses":
            return Optional.ofNullable(clazz.cast(lenses()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "QuestionCounts":
            return Optional.ofNullable(clazz.cast(questionCountsAsStrings()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "ShareInvitationId":
            return Optional.ofNullable(clazz.cast(shareInvitationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplate, T> g) {
        return obj -> g.apply((ReviewTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReviewTemplate> {
        /**
         * <p>
         * The review template description.
         * </p>
         * 
         * @param description
         *        The review template description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The lenses applied to the review template.
         * </p>
         * 
         * @param lenses
         *        The lenses applied to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(Collection<String> lenses);

        /**
         * <p>
         * The lenses applied to the review template.
         * </p>
         * 
         * @param lenses
         *        The lenses applied to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lenses(String... lenses);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * A count of how many total questions are answered and unanswered in the review template.
         * </p>
         * 
         * @param questionCounts
         *        A count of how many total questions are answered and unanswered in the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionCountsWithStrings(Map<String, Integer> questionCounts);

        /**
         * <p>
         * A count of how many total questions are answered and unanswered in the review template.
         * </p>
         * 
         * @param questionCounts
         *        A count of how many total questions are answered and unanswered in the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionCounts(Map<Question, Integer> questionCounts);

        /**
         * Sets the value of the Owner property for this object.
         *
         * @param owner
         *        The new value for the Owner property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The name of the review template.
         * </p>
         * 
         * @param templateName
         *        The name of the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The tags assigned to the review template.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The latest status of a review template.
         * </p>
         * 
         * @param updateStatus
         *        The latest status of a review template.
         * @see ReviewTemplateUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewTemplateUpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The latest status of a review template.
         * </p>
         * 
         * @param updateStatus
         *        The latest status of a review template.
         * @see ReviewTemplateUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewTemplateUpdateStatus
         */
        Builder updateStatus(ReviewTemplateUpdateStatus updateStatus);

        /**
         * <p>
         * The ID assigned to the template share invitation.
         * </p>
         * 
         * @param shareInvitationId
         *        The ID assigned to the template share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareInvitationId(String shareInvitationId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();

        private String notes;

        private Map<String, Integer> questionCounts = DefaultSdkAutoConstructMap.getInstance();

        private String owner;

        private Instant updatedAt;

        private String templateArn;

        private String templateName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String updateStatus;

        private String shareInvitationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplate model) {
            description(model.description);
            lenses(model.lenses);
            notes(model.notes);
            questionCountsWithStrings(model.questionCounts);
            owner(model.owner);
            updatedAt(model.updatedAt);
            templateArn(model.templateArn);
            templateName(model.templateName);
            tags(model.tags);
            updateStatus(model.updateStatus);
            shareInvitationId(model.shareInvitationId);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getLenses() {
            if (lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String... lenses) {
            lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Map<String, Integer> getQuestionCounts() {
            if (questionCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return questionCounts;
        }

        public final void setQuestionCounts(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
        }

        @Override
        public final Builder questionCountsWithStrings(Map<String, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copy(questionCounts);
            return this;
        }

        @Override
        public final Builder questionCounts(Map<Question, Integer> questionCounts) {
            this.questionCounts = QuestionCountsCopier.copyEnumToString(questionCounts);
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ReviewTemplateUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getShareInvitationId() {
            return shareInvitationId;
        }

        public final void setShareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
        }

        @Override
        public final Builder shareInvitationId(String shareInvitationId) {
            this.shareInvitationId = shareInvitationId;
            return this;
        }

        @Override
        public ReviewTemplate build() {
            return new ReviewTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
