/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateReviewTemplateRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<UpdateReviewTemplateRequest.Builder, UpdateReviewTemplateRequest> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(UpdateReviewTemplateRequest::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateArn").build()).build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(UpdateReviewTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateReviewTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(UpdateReviewTemplateRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<List<String>> LENSES_TO_ASSOCIATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LensesToAssociate")
            .getter(getter(UpdateReviewTemplateRequest::lensesToAssociate))
            .setter(setter(Builder::lensesToAssociate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesToAssociate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LENSES_TO_DISASSOCIATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LensesToDisassociate")
            .getter(getter(UpdateReviewTemplateRequest::lensesToDisassociate))
            .setter(setter(Builder::lensesToDisassociate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensesToDisassociate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD,
            TEMPLATE_NAME_FIELD, DESCRIPTION_FIELD, NOTES_FIELD, LENSES_TO_ASSOCIATE_FIELD, LENSES_TO_DISASSOCIATE_FIELD));

    private final String templateArn;

    private final String templateName;

    private final String description;

    private final String notes;

    private final List<String> lensesToAssociate;

    private final List<String> lensesToDisassociate;

    private UpdateReviewTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.description = builder.description;
        this.notes = builder.notes;
        this.lensesToAssociate = builder.lensesToAssociate;
        this.lensesToDisassociate = builder.lensesToDisassociate;
    }

    /**
     * <p>
     * The review template ARN.
     * </p>
     * 
     * @return The review template ARN.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The review template name.
     * </p>
     * 
     * @return The review template name.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The review template description.
     * </p>
     * 
     * @return The review template description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the Notes property for this object.
     * 
     * @return The value of the Notes property for this object.
     */
    public final String notes() {
        return notes;
    }

    /**
     * For responses, this returns true if the service returned a value for the LensesToAssociate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLensesToAssociate() {
        return lensesToAssociate != null && !(lensesToAssociate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lens aliases or ARNs to apply to the review template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLensesToAssociate} method.
     * </p>
     * 
     * @return A list of lens aliases or ARNs to apply to the review template.
     */
    public final List<String> lensesToAssociate() {
        return lensesToAssociate;
    }

    /**
     * For responses, this returns true if the service returned a value for the LensesToDisassociate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLensesToDisassociate() {
        return lensesToDisassociate != null && !(lensesToDisassociate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code> lens cannot be
     * unapplied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLensesToDisassociate} method.
     * </p>
     * 
     * @return A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code> lens
     *         cannot be unapplied.
     */
    public final List<String> lensesToDisassociate() {
        return lensesToDisassociate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(hasLensesToAssociate() ? lensesToAssociate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLensesToDisassociate() ? lensesToDisassociate() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReviewTemplateRequest)) {
            return false;
        }
        UpdateReviewTemplateRequest other = (UpdateReviewTemplateRequest) obj;
        return Objects.equals(templateArn(), other.templateArn()) && Objects.equals(templateName(), other.templateName())
                && Objects.equals(description(), other.description()) && Objects.equals(notes(), other.notes())
                && hasLensesToAssociate() == other.hasLensesToAssociate()
                && Objects.equals(lensesToAssociate(), other.lensesToAssociate())
                && hasLensesToDisassociate() == other.hasLensesToDisassociate()
                && Objects.equals(lensesToDisassociate(), other.lensesToDisassociate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateReviewTemplateRequest").add("TemplateArn", templateArn())
                .add("TemplateName", templateName()).add("Description", description()).add("Notes", notes())
                .add("LensesToAssociate", hasLensesToAssociate() ? lensesToAssociate() : null)
                .add("LensesToDisassociate", hasLensesToDisassociate() ? lensesToDisassociate() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "LensesToAssociate":
            return Optional.ofNullable(clazz.cast(lensesToAssociate()));
        case "LensesToDisassociate":
            return Optional.ofNullable(clazz.cast(lensesToDisassociate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateReviewTemplateRequest, T> g) {
        return obj -> g.apply((UpdateReviewTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateReviewTemplateRequest> {
        /**
         * <p>
         * The review template ARN.
         * </p>
         * 
         * @param templateArn
         *        The review template ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The review template name.
         * </p>
         * 
         * @param templateName
         *        The review template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The review template description.
         * </p>
         * 
         * @param description
         *        The review template description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the Notes property for this object.
         *
         * @param notes
         *        The new value for the Notes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * A list of lens aliases or ARNs to apply to the review template.
         * </p>
         * 
         * @param lensesToAssociate
         *        A list of lens aliases or ARNs to apply to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensesToAssociate(Collection<String> lensesToAssociate);

        /**
         * <p>
         * A list of lens aliases or ARNs to apply to the review template.
         * </p>
         * 
         * @param lensesToAssociate
         *        A list of lens aliases or ARNs to apply to the review template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensesToAssociate(String... lensesToAssociate);

        /**
         * <p>
         * A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code> lens
         * cannot be unapplied.
         * </p>
         * 
         * @param lensesToDisassociate
         *        A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code>
         *        lens cannot be unapplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensesToDisassociate(Collection<String> lensesToDisassociate);

        /**
         * <p>
         * A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code> lens
         * cannot be unapplied.
         * </p>
         * 
         * @param lensesToDisassociate
         *        A list of lens aliases or ARNs to unapply to the review template. The <code>wellarchitected</code>
         *        lens cannot be unapplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lensesToDisassociate(String... lensesToDisassociate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String templateArn;

        private String templateName;

        private String description;

        private String notes;

        private List<String> lensesToAssociate = DefaultSdkAutoConstructList.getInstance();

        private List<String> lensesToDisassociate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReviewTemplateRequest model) {
            super(model);
            templateArn(model.templateArn);
            templateName(model.templateName);
            description(model.description);
            notes(model.notes);
            lensesToAssociate(model.lensesToAssociate);
            lensesToDisassociate(model.lensesToDisassociate);
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final Collection<String> getLensesToAssociate() {
            if (lensesToAssociate instanceof SdkAutoConstructList) {
                return null;
            }
            return lensesToAssociate;
        }

        public final void setLensesToAssociate(Collection<String> lensesToAssociate) {
            this.lensesToAssociate = ReviewTemplateLensAliasesCopier.copy(lensesToAssociate);
        }

        @Override
        public final Builder lensesToAssociate(Collection<String> lensesToAssociate) {
            this.lensesToAssociate = ReviewTemplateLensAliasesCopier.copy(lensesToAssociate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensesToAssociate(String... lensesToAssociate) {
            lensesToAssociate(Arrays.asList(lensesToAssociate));
            return this;
        }

        public final Collection<String> getLensesToDisassociate() {
            if (lensesToDisassociate instanceof SdkAutoConstructList) {
                return null;
            }
            return lensesToDisassociate;
        }

        public final void setLensesToDisassociate(Collection<String> lensesToDisassociate) {
            this.lensesToDisassociate = ReviewTemplateLensAliasesCopier.copy(lensesToDisassociate);
        }

        @Override
        public final Builder lensesToDisassociate(Collection<String> lensesToDisassociate) {
            this.lensesToDisassociate = ReviewTemplateLensAliasesCopier.copy(lensesToDisassociate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lensesToDisassociate(String... lensesToDisassociate) {
            lensesToDisassociate(Arrays.asList(lensesToDisassociate));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateReviewTemplateRequest build() {
            return new UpdateReviewTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
