/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the users or user groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Participants implements SdkPojo, Serializable, ToCopyableBuilder<Participants.Builder, Participants> {
    private static final SdkField<List<UserMetadata>> USERS_FIELD = SdkField
            .<List<UserMetadata>> builder(MarshallingType.LIST)
            .memberName("Users")
            .getter(getter(Participants::users))
            .setter(setter(Builder::users))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GroupMetadata>> GROUPS_FIELD = SdkField
            .<List<GroupMetadata>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(Participants::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERS_FIELD, GROUPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<UserMetadata> users;

    private final List<GroupMetadata> groups;

    private Participants(BuilderImpl builder) {
        this.users = builder.users;
        this.groups = builder.groups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Users property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUsers() {
        return users != null && !(users instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsers} method.
     * </p>
     * 
     * @return The list of users.
     */
    public final List<UserMetadata> users() {
        return users;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The list of user groups.
     */
    public final List<GroupMetadata> groups() {
        return groups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUsers() ? users() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Participants)) {
            return false;
        }
        Participants other = (Participants) obj;
        return hasUsers() == other.hasUsers() && Objects.equals(users(), other.users()) && hasGroups() == other.hasGroups()
                && Objects.equals(groups(), other.groups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Participants").add("Users", hasUsers() ? users() : null)
                .add("Groups", hasGroups() ? groups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Users":
            return Optional.ofNullable(clazz.cast(users()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Participants, T> g) {
        return obj -> g.apply((Participants) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Participants> {
        /**
         * <p>
         * The list of users.
         * </p>
         * 
         * @param users
         *        The list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(Collection<UserMetadata> users);

        /**
         * <p>
         * The list of users.
         * </p>
         * 
         * @param users
         *        The list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder users(UserMetadata... users);

        /**
         * <p>
         * The list of users.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.UserMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workdocs.model.UserMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.UserMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #users(List<UserMetadata>)}.
         * 
         * @param users
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.UserMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #users(java.util.Collection<UserMetadata>)
         */
        Builder users(Consumer<UserMetadata.Builder>... users);

        /**
         * <p>
         * The list of user groups.
         * </p>
         * 
         * @param groups
         *        The list of user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupMetadata> groups);

        /**
         * <p>
         * The list of user groups.
         * </p>
         * 
         * @param groups
         *        The list of user groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupMetadata... groups);

        /**
         * <p>
         * The list of user groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.GroupMetadata.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workdocs.model.GroupMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.GroupMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #groups(List<GroupMetadata>)}.
         * 
         * @param groups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.GroupMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(java.util.Collection<GroupMetadata>)
         */
        Builder groups(Consumer<GroupMetadata.Builder>... groups);
    }

    static final class BuilderImpl implements Builder {
        private List<UserMetadata> users = DefaultSdkAutoConstructList.getInstance();

        private List<GroupMetadata> groups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Participants model) {
            users(model.users);
            groups(model.groups);
        }

        public final List<UserMetadata.Builder> getUsers() {
            List<UserMetadata.Builder> result = UserMetadataListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserMetadata.BuilderImpl> users) {
            this.users = UserMetadataListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<UserMetadata> users) {
            this.users = UserMetadataListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(UserMetadata... users) {
            users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<UserMetadata.Builder>... users) {
            users(Stream.of(users).map(c -> UserMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GroupMetadata.Builder> getGroups() {
            List<GroupMetadata.Builder> result = GroupMetadataListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupMetadata.BuilderImpl> groups) {
            this.groups = GroupMetadataListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupMetadata> groups) {
            this.groups = GroupMetadataListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupMetadata... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupMetadata.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Participants build() {
            return new Participants(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
