/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentityProviderConfigurationRequest extends WorkLinkRequest implements
        ToCopyableBuilder<UpdateIdentityProviderConfigurationRequest.Builder, UpdateIdentityProviderConfigurationRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(UpdateIdentityProviderConfigurationRequest::fleetArn))
            .setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderType")
            .getter(getter(UpdateIdentityProviderConfigurationRequest::identityProviderTypeAsString))
            .setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_SAML_METADATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderSamlMetadata")
            .getter(getter(UpdateIdentityProviderConfigurationRequest::identityProviderSamlMetadata))
            .setter(setter(Builder::identityProviderSamlMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderSamlMetadata")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            IDENTITY_PROVIDER_TYPE_FIELD, IDENTITY_PROVIDER_SAML_METADATA_FIELD));

    private final String fleetArn;

    private final String identityProviderType;

    private final String identityProviderSamlMetadata;

    private UpdateIdentityProviderConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.identityProviderType = builder.identityProviderType;
        this.identityProviderSamlMetadata = builder.identityProviderSamlMetadata;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The type of identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of identity provider.
     * @see IdentityProviderType
     */
    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The type of identity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The type of identity provider.
     * @see IdentityProviderType
     */
    public final String identityProviderTypeAsString() {
        return identityProviderType;
    }

    /**
     * <p>
     * The SAML metadata document provided by the customer’s identity provider. The existing
     * IdentityProviderSamlMetadata is unset if null is passed.
     * </p>
     * 
     * @return The SAML metadata document provided by the customer’s identity provider. The existing
     *         IdentityProviderSamlMetadata is unset if null is passed.
     */
    public final String identityProviderSamlMetadata() {
        return identityProviderSamlMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderSamlMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityProviderConfigurationRequest)) {
            return false;
        }
        UpdateIdentityProviderConfigurationRequest other = (UpdateIdentityProviderConfigurationRequest) obj;
        return Objects.equals(fleetArn(), other.fleetArn())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString())
                && Objects.equals(identityProviderSamlMetadata(), other.identityProviderSamlMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentityProviderConfigurationRequest").add("FleetArn", fleetArn())
                .add("IdentityProviderType", identityProviderTypeAsString())
                .add("IdentityProviderSamlMetadata", identityProviderSamlMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "IdentityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        case "IdentityProviderSamlMetadata":
            return Optional.ofNullable(clazz.cast(identityProviderSamlMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityProviderConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateIdentityProviderConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentityProviderConfigurationRequest> {
        /**
         * <p>
         * The ARN of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The ARN of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The type of identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The type of identity provider.
         * </p>
         * 
         * @param identityProviderType
         *        The type of identity provider.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        /**
         * <p>
         * The SAML metadata document provided by the customer’s identity provider. The existing
         * IdentityProviderSamlMetadata is unset if null is passed.
         * </p>
         * 
         * @param identityProviderSamlMetadata
         *        The SAML metadata document provided by the customer’s identity provider. The existing
         *        IdentityProviderSamlMetadata is unset if null is passed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderSamlMetadata(String identityProviderSamlMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkLinkRequest.BuilderImpl implements Builder {
        private String fleetArn;

        private String identityProviderType;

        private String identityProviderSamlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityProviderConfigurationRequest model) {
            super(model);
            fleetArn(model.fleetArn);
            identityProviderType(model.identityProviderType);
            identityProviderSamlMetadata(model.identityProviderSamlMetadata);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getIdentityProviderType() {
            return identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final String getIdentityProviderSamlMetadata() {
            return identityProviderSamlMetadata;
        }

        public final void setIdentityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
        }

        @Override
        public final Builder identityProviderSamlMetadata(String identityProviderSamlMetadata) {
            this.identityProviderSamlMetadata = identityProviderSamlMetadata;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityProviderConfigurationRequest build() {
            return new UpdateIdentityProviderConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
