/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon Web Services accounts that have been granted permission to use a shared image. For more
 * information about sharing images, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a Custom
 * WorkSpaces Image</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImagePermission implements SdkPojo, Serializable, ToCopyableBuilder<ImagePermission.Builder, ImagePermission> {
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedAccountId").getter(getter(ImagePermission::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_ACCOUNT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sharedAccountId;

    private ImagePermission(BuilderImpl builder) {
        this.sharedAccountId = builder.sharedAccountId;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that an image has been shared with.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that an image has been shared with.
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImagePermission)) {
            return false;
        }
        ImagePermission other = (ImagePermission) obj;
        return Objects.equals(sharedAccountId(), other.sharedAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImagePermission").add("SharedAccountId", sharedAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImagePermission, T> g) {
        return obj -> g.apply((ImagePermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImagePermission> {
        /**
         * <p>
         * The identifier of the Amazon Web Services account that an image has been shared with.
         * </p>
         * 
         * @param sharedAccountId
         *        The identifier of the Amazon Web Services account that an image has been shared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String sharedAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(ImagePermission model) {
            sharedAccountId(model.sharedAccountId);
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        @Override
        public ImagePermission build() {
            return new ImagePermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
