/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a WorkSpace bundle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceBundle implements SdkPojo, Serializable, ToCopyableBuilder<WorkspaceBundle.Builder, WorkspaceBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(WorkspaceBundle::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WorkspaceBundle::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(WorkspaceBundle::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WorkspaceBundle::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(WorkspaceBundle::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<RootStorage> ROOT_STORAGE_FIELD = SdkField.<RootStorage> builder(MarshallingType.SDK_POJO)
            .memberName("RootStorage").getter(getter(WorkspaceBundle::rootStorage)).setter(setter(Builder::rootStorage))
            .constructor(RootStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootStorage").build()).build();

    private static final SdkField<UserStorage> USER_STORAGE_FIELD = SdkField.<UserStorage> builder(MarshallingType.SDK_POJO)
            .memberName("UserStorage").getter(getter(WorkspaceBundle::userStorage)).setter(setter(Builder::userStorage))
            .constructor(UserStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStorage").build()).build();

    private static final SdkField<ComputeType> COMPUTE_TYPE_FIELD = SdkField.<ComputeType> builder(MarshallingType.SDK_POJO)
            .memberName("ComputeType").getter(getter(WorkspaceBundle::computeType)).setter(setter(Builder::computeType))
            .constructor(ComputeType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(WorkspaceBundle::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(WorkspaceBundle::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD,
            OWNER_FIELD, DESCRIPTION_FIELD, IMAGE_ID_FIELD, ROOT_STORAGE_FIELD, USER_STORAGE_FIELD, COMPUTE_TYPE_FIELD,
            LAST_UPDATED_TIME_FIELD, CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bundleId;

    private final String name;

    private final String owner;

    private final String description;

    private final String imageId;

    private final RootStorage rootStorage;

    private final UserStorage userStorage;

    private final ComputeType computeType;

    private final Instant lastUpdatedTime;

    private final Instant creationTime;

    private WorkspaceBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.rootStorage = builder.rootStorage;
        this.userStorage = builder.userStorage;
        this.computeType = builder.computeType;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The identifier of the bundle.
     * </p>
     * 
     * @return The identifier of the bundle.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The name of the bundle.
     * </p>
     * 
     * @return The name of the bundle.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner of the bundle. This is the account identifier of the owner, or <code>AMAZON</code> if the bundle is
     * provided by Amazon Web Services.
     * </p>
     * 
     * @return The owner of the bundle. This is the account identifier of the owner, or <code>AMAZON</code> if the
     *         bundle is provided by Amazon Web Services.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The description of the bundle.
     * </p>
     * 
     * @return The description of the bundle.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the image that was used to create the bundle.
     * </p>
     * 
     * @return The identifier of the image that was used to create the bundle.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The size of the root volume.
     * </p>
     * 
     * @return The size of the root volume.
     */
    public final RootStorage rootStorage() {
        return rootStorage;
    }

    /**
     * <p>
     * The size of the user volume.
     * </p>
     * 
     * @return The size of the user volume.
     */
    public final UserStorage userStorage() {
        return userStorage;
    }

    /**
     * <p>
     * The compute type of the bundle. For more information, see <a
     * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     * </p>
     * 
     * @return The compute type of the bundle. For more information, see <a
     *         href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
     */
    public final ComputeType computeType() {
        return computeType;
    }

    /**
     * <p>
     * The last time that the bundle was updated.
     * </p>
     * 
     * @return The last time that the bundle was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The time when the bundle was created.
     * </p>
     * 
     * @return The time when the bundle was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(rootStorage());
        hashCode = 31 * hashCode + Objects.hashCode(userStorage());
        hashCode = 31 * hashCode + Objects.hashCode(computeType());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceBundle)) {
            return false;
        }
        WorkspaceBundle other = (WorkspaceBundle) obj;
        return Objects.equals(bundleId(), other.bundleId()) && Objects.equals(name(), other.name())
                && Objects.equals(owner(), other.owner()) && Objects.equals(description(), other.description())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(rootStorage(), other.rootStorage())
                && Objects.equals(userStorage(), other.userStorage()) && Objects.equals(computeType(), other.computeType())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceBundle").add("BundleId", bundleId()).add("Name", name()).add("Owner", owner())
                .add("Description", description()).add("ImageId", imageId()).add("RootStorage", rootStorage())
                .add("UserStorage", userStorage()).add("ComputeType", computeType()).add("LastUpdatedTime", lastUpdatedTime())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "RootStorage":
            return Optional.ofNullable(clazz.cast(rootStorage()));
        case "UserStorage":
            return Optional.ofNullable(clazz.cast(userStorage()));
        case "ComputeType":
            return Optional.ofNullable(clazz.cast(computeType()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceBundle, T> g) {
        return obj -> g.apply((WorkspaceBundle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceBundle> {
        /**
         * <p>
         * The identifier of the bundle.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The name of the bundle.
         * </p>
         * 
         * @param name
         *        The name of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner of the bundle. This is the account identifier of the owner, or <code>AMAZON</code> if the bundle is
         * provided by Amazon Web Services.
         * </p>
         * 
         * @param owner
         *        The owner of the bundle. This is the account identifier of the owner, or <code>AMAZON</code> if the
         *        bundle is provided by Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The description of the bundle.
         * </p>
         * 
         * @param description
         *        The description of the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the image that was used to create the bundle.
         * </p>
         * 
         * @param imageId
         *        The identifier of the image that was used to create the bundle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The size of the root volume.
         * </p>
         * 
         * @param rootStorage
         *        The size of the root volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootStorage(RootStorage rootStorage);

        /**
         * <p>
         * The size of the root volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link RootStorage.Builder} avoiding the need to
         * create one manually via {@link RootStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RootStorage.Builder#build()} is called immediately and its result
         * is passed to {@link #rootStorage(RootStorage)}.
         * 
         * @param rootStorage
         *        a consumer that will call methods on {@link RootStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootStorage(RootStorage)
         */
        default Builder rootStorage(Consumer<RootStorage.Builder> rootStorage) {
            return rootStorage(RootStorage.builder().applyMutation(rootStorage).build());
        }

        /**
         * <p>
         * The size of the user volume.
         * </p>
         * 
         * @param userStorage
         *        The size of the user volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStorage(UserStorage userStorage);

        /**
         * <p>
         * The size of the user volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserStorage.Builder} avoiding the need to
         * create one manually via {@link UserStorage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserStorage.Builder#build()} is called immediately and its result
         * is passed to {@link #userStorage(UserStorage)}.
         * 
         * @param userStorage
         *        a consumer that will call methods on {@link UserStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userStorage(UserStorage)
         */
        default Builder userStorage(Consumer<UserStorage.Builder> userStorage) {
            return userStorage(UserStorage.builder().applyMutation(userStorage).build());
        }

        /**
         * <p>
         * The compute type of the bundle. For more information, see <a
         * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
         * </p>
         * 
         * @param computeType
         *        The compute type of the bundle. For more information, see <a
         *        href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces
         *        Bundles</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * The compute type of the bundle. For more information, see <a
         * href="http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles">Amazon WorkSpaces Bundles</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeType.Builder} avoiding the need to
         * create one manually via {@link ComputeType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeType.Builder#build()} is called immediately and its result
         * is passed to {@link #computeType(ComputeType)}.
         * 
         * @param computeType
         *        a consumer that will call methods on {@link ComputeType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeType(ComputeType)
         */
        default Builder computeType(Consumer<ComputeType.Builder> computeType) {
            return computeType(ComputeType.builder().applyMutation(computeType).build());
        }

        /**
         * <p>
         * The last time that the bundle was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that the bundle was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The time when the bundle was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the bundle was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String bundleId;

        private String name;

        private String owner;

        private String description;

        private String imageId;

        private RootStorage rootStorage;

        private UserStorage userStorage;

        private ComputeType computeType;

        private Instant lastUpdatedTime;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceBundle model) {
            bundleId(model.bundleId);
            name(model.name);
            owner(model.owner);
            description(model.description);
            imageId(model.imageId);
            rootStorage(model.rootStorage);
            userStorage(model.userStorage);
            computeType(model.computeType);
            lastUpdatedTime(model.lastUpdatedTime);
            creationTime(model.creationTime);
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final RootStorage.Builder getRootStorage() {
            return rootStorage != null ? rootStorage.toBuilder() : null;
        }

        public final void setRootStorage(RootStorage.BuilderImpl rootStorage) {
            this.rootStorage = rootStorage != null ? rootStorage.build() : null;
        }

        @Override
        public final Builder rootStorage(RootStorage rootStorage) {
            this.rootStorage = rootStorage;
            return this;
        }

        public final UserStorage.Builder getUserStorage() {
            return userStorage != null ? userStorage.toBuilder() : null;
        }

        public final void setUserStorage(UserStorage.BuilderImpl userStorage) {
            this.userStorage = userStorage != null ? userStorage.build() : null;
        }

        @Override
        public final Builder userStorage(UserStorage userStorage) {
            this.userStorage = userStorage;
            return this;
        }

        public final ComputeType.Builder getComputeType() {
            return computeType != null ? computeType.toBuilder() : null;
        }

        public final void setComputeType(ComputeType.BuilderImpl computeType) {
            this.computeType = computeType != null ? computeType.build() : null;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType = computeType;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public WorkspaceBundle build() {
            return new WorkspaceBundle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
