/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.DataReplication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataReplicationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataReplicationSettings> {
    private static final SdkField<String> DATA_REPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataReplication").getter(DataReplicationSettings.getter(DataReplicationSettings::dataReplicationAsString)).setter(DataReplicationSettings.setter(Builder::dataReplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataReplication").build()}).build();
    private static final SdkField<Instant> RECOVERY_SNAPSHOT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RecoverySnapshotTime").getter(DataReplicationSettings.getter(DataReplicationSettings::recoverySnapshotTime)).setter(DataReplicationSettings.setter(Builder::recoverySnapshotTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoverySnapshotTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPLICATION_FIELD, RECOVERY_SNAPSHOT_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataReplication;
    private final Instant recoverySnapshotTime;

    private DataReplicationSettings(BuilderImpl builder) {
        this.dataReplication = builder.dataReplication;
        this.recoverySnapshotTime = builder.recoverySnapshotTime;
    }

    public final DataReplication dataReplication() {
        return DataReplication.fromValue(this.dataReplication);
    }

    public final String dataReplicationAsString() {
        return this.dataReplication;
    }

    public final Instant recoverySnapshotTime() {
        return this.recoverySnapshotTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoverySnapshotTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationSettings)) {
            return false;
        }
        DataReplicationSettings other = (DataReplicationSettings)obj;
        return Objects.equals(this.dataReplicationAsString(), other.dataReplicationAsString()) && Objects.equals(this.recoverySnapshotTime(), other.recoverySnapshotTime());
    }

    public final String toString() {
        return ToString.builder((String)"DataReplicationSettings").add("DataReplication", (Object)this.dataReplicationAsString()).add("RecoverySnapshotTime", (Object)this.recoverySnapshotTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataReplication": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationAsString()));
            }
            case "RecoverySnapshotTime": {
                return Optional.ofNullable(clazz.cast(this.recoverySnapshotTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationSettings, T> g) {
        return obj -> g.apply((DataReplicationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataReplication;
        private Instant recoverySnapshotTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationSettings model) {
            this.dataReplication(model.dataReplication);
            this.recoverySnapshotTime(model.recoverySnapshotTime);
        }

        public final String getDataReplication() {
            return this.dataReplication;
        }

        public final void setDataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
        }

        @Override
        public final Builder dataReplication(String dataReplication) {
            this.dataReplication = dataReplication;
            return this;
        }

        @Override
        public final Builder dataReplication(DataReplication dataReplication) {
            this.dataReplication(dataReplication == null ? null : dataReplication.toString());
            return this;
        }

        public final Instant getRecoverySnapshotTime() {
            return this.recoverySnapshotTime;
        }

        public final void setRecoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
        }

        @Override
        public final Builder recoverySnapshotTime(Instant recoverySnapshotTime) {
            this.recoverySnapshotTime = recoverySnapshotTime;
            return this;
        }

        public DataReplicationSettings build() {
            return new DataReplicationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataReplicationSettings> {
        public Builder dataReplication(String var1);

        public Builder dataReplication(DataReplication var1);

        public Builder recoverySnapshotTime(Instant var1);
    }
}

