/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the information used to create a WorkSpace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceRequest.Builder, WorkspaceRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(WorkspaceRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(WorkspaceRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BundleId").getter(getter(WorkspaceRequest::bundleId)).setter(setter(Builder::bundleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BundleId").build()).build();

    private static final SdkField<String> VOLUME_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeEncryptionKey").getter(getter(WorkspaceRequest::volumeEncryptionKey))
            .setter(setter(Builder::volumeEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeEncryptionKey").build())
            .build();

    private static final SdkField<Boolean> USER_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UserVolumeEncryptionEnabled")
            .getter(getter(WorkspaceRequest::userVolumeEncryptionEnabled))
            .setter(setter(Builder::userVolumeEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserVolumeEncryptionEnabled")
                    .build()).build();

    private static final SdkField<Boolean> ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RootVolumeEncryptionEnabled")
            .getter(getter(WorkspaceRequest::rootVolumeEncryptionEnabled))
            .setter(setter(Builder::rootVolumeEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolumeEncryptionEnabled")
                    .build()).build();

    private static final SdkField<WorkspaceProperties> WORKSPACE_PROPERTIES_FIELD = SdkField
            .<WorkspaceProperties> builder(MarshallingType.SDK_POJO).memberName("WorkspaceProperties")
            .getter(getter(WorkspaceRequest::workspaceProperties)).setter(setter(Builder::workspaceProperties))
            .constructor(WorkspaceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(WorkspaceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            USER_NAME_FIELD, BUNDLE_ID_FIELD, VOLUME_ENCRYPTION_KEY_FIELD, USER_VOLUME_ENCRYPTION_ENABLED_FIELD,
            ROOT_VOLUME_ENCRYPTION_ENABLED_FIELD, WORKSPACE_PROPERTIES_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String userName;

    private final String bundleId;

    private final String volumeEncryptionKey;

    private final Boolean userVolumeEncryptionEnabled;

    private final Boolean rootVolumeEncryptionEnabled;

    private final WorkspaceProperties workspaceProperties;

    private final List<Tag> tags;

    private WorkspaceRequest(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.bundleId = builder.bundleId;
        this.volumeEncryptionKey = builder.volumeEncryptionKey;
        this.userVolumeEncryptionEnabled = builder.userVolumeEncryptionEnabled;
        this.rootVolumeEncryptionEnabled = builder.rootVolumeEncryptionEnabled;
        this.workspaceProperties = builder.workspaceProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier of the Directory Service directory for the WorkSpace. You can use
     * <a>DescribeWorkspaceDirectories</a> to list the available directories.
     * </p>
     * 
     * @return The identifier of the Directory Service directory for the WorkSpace. You can use
     *         <a>DescribeWorkspaceDirectories</a> to list the available directories.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory for the
     * WorkSpace.
     * </p>
     * 
     * @return The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory
     *         for the WorkSpace.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the available
     * bundles.
     * </p>
     * 
     * @return The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the
     *         available bundles.
     */
    public final String bundleId() {
        return bundleId;
    }

    /**
     * <p>
     * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not
     * support asymmetric KMS keys.
     * </p>
     * 
     * @return The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does
     *         not support asymmetric KMS keys.
     */
    public final String volumeEncryptionKey() {
        return volumeEncryptionKey;
    }

    /**
     * <p>
     * Indicates whether the data stored on the user volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the data stored on the user volume is encrypted.
     */
    public final Boolean userVolumeEncryptionEnabled() {
        return userVolumeEncryptionEnabled;
    }

    /**
     * <p>
     * Indicates whether the data stored on the root volume is encrypted.
     * </p>
     * 
     * @return Indicates whether the data stored on the root volume is encrypted.
     */
    public final Boolean rootVolumeEncryptionEnabled() {
        return rootVolumeEncryptionEnabled;
    }

    /**
     * <p>
     * The WorkSpace properties.
     * </p>
     * 
     * @return The WorkSpace properties.
     */
    public final WorkspaceProperties workspaceProperties() {
        return workspaceProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for the WorkSpace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the WorkSpace.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(userVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rootVolumeEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceRequest)) {
            return false;
        }
        WorkspaceRequest other = (WorkspaceRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(userName(), other.userName())
                && Objects.equals(bundleId(), other.bundleId())
                && Objects.equals(volumeEncryptionKey(), other.volumeEncryptionKey())
                && Objects.equals(userVolumeEncryptionEnabled(), other.userVolumeEncryptionEnabled())
                && Objects.equals(rootVolumeEncryptionEnabled(), other.rootVolumeEncryptionEnabled())
                && Objects.equals(workspaceProperties(), other.workspaceProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceRequest").add("DirectoryId", directoryId()).add("UserName", userName())
                .add("BundleId", bundleId()).add("VolumeEncryptionKey", volumeEncryptionKey())
                .add("UserVolumeEncryptionEnabled", userVolumeEncryptionEnabled())
                .add("RootVolumeEncryptionEnabled", rootVolumeEncryptionEnabled())
                .add("WorkspaceProperties", workspaceProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "BundleId":
            return Optional.ofNullable(clazz.cast(bundleId()));
        case "VolumeEncryptionKey":
            return Optional.ofNullable(clazz.cast(volumeEncryptionKey()));
        case "UserVolumeEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(userVolumeEncryptionEnabled()));
        case "RootVolumeEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(rootVolumeEncryptionEnabled()));
        case "WorkspaceProperties":
            return Optional.ofNullable(clazz.cast(workspaceProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceRequest, T> g) {
        return obj -> g.apply((WorkspaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceRequest> {
        /**
         * <p>
         * The identifier of the Directory Service directory for the WorkSpace. You can use
         * <a>DescribeWorkspaceDirectories</a> to list the available directories.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the Directory Service directory for the WorkSpace. You can use
         *        <a>DescribeWorkspaceDirectories</a> to list the available directories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The user name of the user for the WorkSpace. This user name must exist in the Directory Service directory for
         * the WorkSpace.
         * </p>
         * 
         * @param userName
         *        The user name of the user for the WorkSpace. This user name must exist in the Directory Service
         *        directory for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list the
         * available bundles.
         * </p>
         * 
         * @param bundleId
         *        The identifier of the bundle for the WorkSpace. You can use <a>DescribeWorkspaceBundles</a> to list
         *        the available bundles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);

        /**
         * <p>
         * The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not
         * support asymmetric KMS keys.
         * </p>
         * 
         * @param volumeEncryptionKey
         *        The ARN of the symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does
         *        not support asymmetric KMS keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeEncryptionKey(String volumeEncryptionKey);

        /**
         * <p>
         * Indicates whether the data stored on the user volume is encrypted.
         * </p>
         * 
         * @param userVolumeEncryptionEnabled
         *        Indicates whether the data stored on the user volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled);

        /**
         * <p>
         * Indicates whether the data stored on the root volume is encrypted.
         * </p>
         * 
         * @param rootVolumeEncryptionEnabled
         *        Indicates whether the data stored on the root volume is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled);

        /**
         * <p>
         * The WorkSpace properties.
         * </p>
         * 
         * @param workspaceProperties
         *        The WorkSpace properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceProperties(WorkspaceProperties workspaceProperties);

        /**
         * <p>
         * The WorkSpace properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceProperties.Builder} avoiding the
         * need to create one manually via {@link WorkspaceProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #workspaceProperties(WorkspaceProperties)}.
         * 
         * @param workspaceProperties
         *        a consumer that will call methods on {@link WorkspaceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workspaceProperties(WorkspaceProperties)
         */
        default Builder workspaceProperties(Consumer<WorkspaceProperties.Builder> workspaceProperties) {
            return workspaceProperties(WorkspaceProperties.builder().applyMutation(workspaceProperties).build());
        }

        /**
         * <p>
         * The tags for the WorkSpace.
         * </p>
         * 
         * @param tags
         *        The tags for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for the WorkSpace.
         * </p>
         * 
         * @param tags
         *        The tags for the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for the WorkSpace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String userName;

        private String bundleId;

        private String volumeEncryptionKey;

        private Boolean userVolumeEncryptionEnabled;

        private Boolean rootVolumeEncryptionEnabled;

        private WorkspaceProperties workspaceProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceRequest model) {
            directoryId(model.directoryId);
            userName(model.userName);
            bundleId(model.bundleId);
            volumeEncryptionKey(model.volumeEncryptionKey);
            userVolumeEncryptionEnabled(model.userVolumeEncryptionEnabled);
            rootVolumeEncryptionEnabled(model.rootVolumeEncryptionEnabled);
            workspaceProperties(model.workspaceProperties);
            tags(model.tags);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getBundleId() {
            return bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getVolumeEncryptionKey() {
            return volumeEncryptionKey;
        }

        public final void setVolumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
        }

        @Override
        public final Builder volumeEncryptionKey(String volumeEncryptionKey) {
            this.volumeEncryptionKey = volumeEncryptionKey;
            return this;
        }

        public final Boolean getUserVolumeEncryptionEnabled() {
            return userVolumeEncryptionEnabled;
        }

        public final void setUserVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
        }

        @Override
        public final Builder userVolumeEncryptionEnabled(Boolean userVolumeEncryptionEnabled) {
            this.userVolumeEncryptionEnabled = userVolumeEncryptionEnabled;
            return this;
        }

        public final Boolean getRootVolumeEncryptionEnabled() {
            return rootVolumeEncryptionEnabled;
        }

        public final void setRootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
        }

        @Override
        public final Builder rootVolumeEncryptionEnabled(Boolean rootVolumeEncryptionEnabled) {
            this.rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled;
            return this;
        }

        public final WorkspaceProperties.Builder getWorkspaceProperties() {
            return workspaceProperties != null ? workspaceProperties.toBuilder() : null;
        }

        public final void setWorkspaceProperties(WorkspaceProperties.BuilderImpl workspaceProperties) {
            this.workspaceProperties = workspaceProperties != null ? workspaceProperties.build() : null;
        }

        @Override
        public final Builder workspaceProperties(WorkspaceProperties workspaceProperties) {
            this.workspaceProperties = workspaceProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WorkspaceRequest build() {
            return new WorkspaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
