/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.AssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionAliasAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionAliasAssociation> {
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationStatus").getter(ConnectionAliasAssociation.getter(ConnectionAliasAssociation::associationStatusAsString)).setter(ConnectionAliasAssociation.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatus").build()}).build();
    private static final SdkField<String> ASSOCIATED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociatedAccountId").getter(ConnectionAliasAssociation.getter(ConnectionAliasAssociation::associatedAccountId)).setter(ConnectionAliasAssociation.setter(Builder::associatedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedAccountId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ConnectionAliasAssociation.getter(ConnectionAliasAssociation::resourceId)).setter(ConnectionAliasAssociation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> CONNECTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionIdentifier").getter(ConnectionAliasAssociation.getter(ConnectionAliasAssociation::connectionIdentifier)).setter(ConnectionAliasAssociation.setter(Builder::connectionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_STATUS_FIELD, ASSOCIATED_ACCOUNT_ID_FIELD, RESOURCE_ID_FIELD, CONNECTION_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationStatus;
    private final String associatedAccountId;
    private final String resourceId;
    private final String connectionIdentifier;

    private ConnectionAliasAssociation(BuilderImpl builder) {
        this.associationStatus = builder.associationStatus;
        this.associatedAccountId = builder.associatedAccountId;
        this.resourceId = builder.resourceId;
        this.connectionIdentifier = builder.connectionIdentifier;
    }

    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final String associatedAccountId() {
        return this.associatedAccountId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String connectionIdentifier() {
        return this.connectionIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionAliasAssociation)) {
            return false;
        }
        ConnectionAliasAssociation other = (ConnectionAliasAssociation)obj;
        return Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.associatedAccountId(), other.associatedAccountId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.connectionIdentifier(), other.connectionIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionAliasAssociation").add("AssociationStatus", (Object)this.associationStatusAsString()).add("AssociatedAccountId", (Object)this.associatedAccountId()).add("ResourceId", (Object)this.resourceId()).add("ConnectionIdentifier", (Object)this.connectionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "AssociatedAccountId": {
                return Optional.ofNullable(clazz.cast(this.associatedAccountId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ConnectionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.connectionIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionAliasAssociation, T> g) {
        return obj -> g.apply((ConnectionAliasAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationStatus;
        private String associatedAccountId;
        private String resourceId;
        private String connectionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionAliasAssociation model) {
            this.associationStatus(model.associationStatus);
            this.associatedAccountId(model.associatedAccountId);
            this.resourceId(model.resourceId);
            this.connectionIdentifier(model.connectionIdentifier);
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getAssociatedAccountId() {
            return this.associatedAccountId;
        }

        public final void setAssociatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
        }

        @Override
        public final Builder associatedAccountId(String associatedAccountId) {
            this.associatedAccountId = associatedAccountId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getConnectionIdentifier() {
            return this.connectionIdentifier;
        }

        public final void setConnectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
        }

        @Override
        public final Builder connectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
            return this;
        }

        public ConnectionAliasAssociation build() {
            return new ConnectionAliasAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionAliasAssociation> {
        public Builder associationStatus(String var1);

        public Builder associationStatus(AssociationStatus var1);

        public Builder associatedAccountId(String var1);

        public Builder resourceId(String var1);

        public Builder connectionIdentifier(String var1);
    }
}

