/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEnvironmentRequest extends WorkSpacesThinClientRequest implements
        ToCopyableBuilder<UpdateEnvironmentRequest.Builder, UpdateEnvironmentRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateEnvironmentRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopArn").getter(getter(UpdateEnvironmentRequest::desktopArn)).setter(setter(Builder::desktopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()).build();

    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopEndpoint").getter(getter(UpdateEnvironmentRequest::desktopEndpoint))
            .setter(setter(Builder::desktopEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()).build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateSchedule").getter(getter(UpdateEnvironmentRequest::softwareSetUpdateScheduleAsString))
            .setter(setter(Builder::softwareSetUpdateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build())
            .build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(UpdateEnvironmentRequest::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateMode").getter(getter(UpdateEnvironmentRequest::softwareSetUpdateModeAsString))
            .setter(setter(Builder::softwareSetUpdateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build())
            .build();

    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredSoftwareSetId").getter(getter(UpdateEnvironmentRequest::desiredSoftwareSetId))
            .setter(setter(Builder::desiredSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD,
            SOFTWARE_SET_UPDATE_MODE_FIELD, DESIRED_SOFTWARE_SET_ID_FIELD));

    private final String id;

    private final String name;

    private final String desktopArn;

    private final String desktopEndpoint;

    private final String softwareSetUpdateSchedule;

    private final MaintenanceWindow maintenanceWindow;

    private final String softwareSetUpdateMode;

    private final String desiredSoftwareSetId;

    private UpdateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
    }

    /**
     * <p>
     * The ID of the environment to update.
     * </p>
     * 
     * @return The ID of the environment to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment to update.
     * </p>
     * 
     * @return The name of the environment to update.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
     *         AppStream 2.0.
     */
    public final String desktopArn() {
        return desktopArn;
    }

    /**
     * <p>
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     * </p>
     * 
     * @return The URL for the identity provider login (only for environments that use AppStream 2.0).
     */
    public final String desktopEndpoint() {
        return desktopEndpoint;
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(softwareSetUpdateSchedule);
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final String softwareSetUpdateScheduleAsString() {
        return softwareSetUpdateSchedule;
    }

    /**
     * <p>
     * A specification for a time window to apply software updates.
     * </p>
     * 
     * @return A specification for a time window to apply software updates.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(softwareSetUpdateMode);
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final String softwareSetUpdateModeAsString() {
        return softwareSetUpdateMode;
    }

    /**
     * <p>
     * The ID of the software set to apply.
     * </p>
     * 
     * @return The ID of the software set to apply.
     */
    public final String desiredSoftwareSetId() {
        return desiredSoftwareSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSoftwareSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentRequest)) {
            return false;
        }
        UpdateEnvironmentRequest other = (UpdateEnvironmentRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(desktopArn(), other.desktopArn()) && Objects.equals(desktopEndpoint(), other.desktopEndpoint())
                && Objects.equals(softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString())
                && Objects.equals(desiredSoftwareSetId(), other.desiredSoftwareSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateEnvironmentRequest").add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("DesktopArn", desktopArn())
                .add("DesktopEndpoint", desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SoftwareSetUpdateSchedule", softwareSetUpdateScheduleAsString())
                .add("MaintenanceWindow", maintenanceWindow()).add("SoftwareSetUpdateMode", softwareSetUpdateModeAsString())
                .add("DesiredSoftwareSetId", desiredSoftwareSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "desktopArn":
            return Optional.ofNullable(clazz.cast(desktopArn()));
        case "desktopEndpoint":
            return Optional.ofNullable(clazz.cast(desktopEndpoint()));
        case "softwareSetUpdateSchedule":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateScheduleAsString()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "softwareSetUpdateMode":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateModeAsString()));
        case "desiredSoftwareSetId":
            return Optional.ofNullable(clazz.cast(desiredSoftwareSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesThinClientRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEnvironmentRequest> {
        /**
         * <p>
         * The ID of the environment to update.
         * </p>
         * 
         * @param id
         *        The ID of the environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment to update.
         * </p>
         * 
         * @param name
         *        The name of the environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream
         * 2.0.
         * </p>
         * 
         * @param desktopArn
         *        The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
         *        AppStream 2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopArn(String desktopArn);

        /**
         * <p>
         * The URL for the identity provider login (only for environments that use AppStream 2.0).
         * </p>
         * 
         * @param desktopEndpoint
         *        The URL for the identity provider login (only for environments that use AppStream 2.0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopEndpoint(String desktopEndpoint);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * 
         * @param maintenanceWindow
         *        A specification for a time window to apply software updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(String softwareSetUpdateMode);

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode);

        /**
         * <p>
         * The ID of the software set to apply.
         * </p>
         * 
         * @param desiredSoftwareSetId
         *        The ID of the software set to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSoftwareSetId(String desiredSoftwareSetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesThinClientRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String desktopArn;

        private String desktopEndpoint;

        private String softwareSetUpdateSchedule;

        private MaintenanceWindow maintenanceWindow;

        private String softwareSetUpdateMode;

        private String desiredSoftwareSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            desktopArn(model.desktopArn);
            desktopEndpoint(model.desktopEndpoint);
            softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            maintenanceWindow(model.maintenanceWindow);
            softwareSetUpdateMode(model.softwareSetUpdateMode);
            desiredSoftwareSetId(model.desiredSoftwareSetId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnvironmentRequest build() {
            return new UpdateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
