/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateUserSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<AssociateUserSettingsRequest.Builder, AssociateUserSettingsRequest> {
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(AssociateUserSettingsRequest::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("portalArn").build()).build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(AssociateUserSettingsRequest::userSettingsArn))
            .setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("userSettingsArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ARN_FIELD,
            USER_SETTINGS_ARN_FIELD));

    private final String portalArn;

    private final String userSettingsArn;

    private AssociateUserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.portalArn = builder.portalArn;
        this.userSettingsArn = builder.userSettingsArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The ARN of the user settings.
     * </p>
     * 
     * @return The ARN of the user settings.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateUserSettingsRequest)) {
            return false;
        }
        AssociateUserSettingsRequest other = (AssociateUserSettingsRequest) obj;
        return Objects.equals(portalArn(), other.portalArn()) && Objects.equals(userSettingsArn(), other.userSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateUserSettingsRequest").add("PortalArn", portalArn())
                .add("UserSettingsArn", userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateUserSettingsRequest, T> g) {
        return obj -> g.apply((AssociateUserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateUserSettingsRequest> {
        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The ARN of the user settings.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String portalArn;

        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateUserSettingsRequest model) {
            super(model);
            portalArn(model.portalArn);
            userSettingsArn(model.userSettingsArn);
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateUserSettingsRequest build() {
            return new AssociateUserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
