/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends XRayRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(CreateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(CreateGroupRequest::filterExpression))
            .setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<InsightsConfiguration> INSIGHTS_CONFIGURATION_FIELD = SdkField
            .<InsightsConfiguration> builder(MarshallingType.SDK_POJO).memberName("InsightsConfiguration")
            .getter(getter(CreateGroupRequest::insightsConfiguration)).setter(setter(Builder::insightsConfiguration))
            .constructor(InsightsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsConfiguration").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            FILTER_EXPRESSION_FIELD, INSIGHTS_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String groupName;

    private final String filterExpression;

    private final InsightsConfiguration insightsConfiguration;

    private final List<Tag> tags;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.filterExpression = builder.filterExpression;
        this.insightsConfiguration = builder.insightsConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The case-sensitive name of the new group. Default is a reserved name and names must be unique.
     * </p>
     * 
     * @return The case-sensitive name of the new group. Default is a reserved name and names must be unique.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The filter expression defining criteria by which to group traces.
     * </p>
     * 
     * @return The filter expression defining criteria by which to group traces.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * The structure containing configurations related to insights.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable insights
     * for the new group.
     * </p>
     * </li>
     * <li>
     * <p>
     * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group.
     * Notifications may only be enabled on a group with InsightsEnabled set to true.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The structure containing configurations related to insights.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable
     *         insights for the new group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group.
     *         Notifications may only be enabled on a group with InsightsEnabled set to true.
     *         </p>
     *         </li>
     */
    public final InsightsConfiguration insightsConfiguration() {
        return insightsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information about
     * ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web
     * Services resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * The following restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of user-applied tags per resource: 50
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum tag key length: 128 Unicode characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum tag value length: 256 Unicode characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information
     *         about ways to use tags, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
     *         <p>
     *         The following restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of user-applied tags per resource: 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum tag key length: 128 Unicode characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum tag value length: 256 Unicode characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(insightsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(insightsConfiguration(), other.insightsConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGroupRequest").add("GroupName", groupName()).add("FilterExpression", filterExpression())
                .add("InsightsConfiguration", insightsConfiguration()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "InsightsConfiguration":
            return Optional.ofNullable(clazz.cast(insightsConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * The case-sensitive name of the new group. Default is a reserved name and names must be unique.
         * </p>
         * 
         * @param groupName
         *        The case-sensitive name of the new group. Default is a reserved name and names must be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The filter expression defining criteria by which to group traces.
         * </p>
         * 
         * @param filterExpression
         *        The filter expression defining criteria by which to group traces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable
         * insights for the new group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group.
         * Notifications may only be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * 
         * @param insightsConfiguration
         *        The structure containing configurations related to insights.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The InsightsEnabled boolean can be set to true to enable insights for the new group or false to
         *        disable insights for the new group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group.
         *        Notifications may only be enabled on a group with InsightsEnabled set to true.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightsConfiguration(InsightsConfiguration insightsConfiguration);

        /**
         * <p>
         * The structure containing configurations related to insights.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The InsightsEnabled boolean can be set to true to enable insights for the new group or false to disable
         * insights for the new group.
         * </p>
         * </li>
         * <li>
         * <p>
         * The NotifcationsEnabled boolean can be set to true to enable insights notifications for the new group.
         * Notifications may only be enabled on a group with InsightsEnabled set to true.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link InsightsConfiguration.Builder} avoiding
         * the need to create one manually via {@link InsightsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #insightsConfiguration(InsightsConfiguration)}.
         * 
         * @param insightsConfiguration
         *        a consumer that will call methods on {@link InsightsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightsConfiguration(InsightsConfiguration)
         */
        default Builder insightsConfiguration(Consumer<InsightsConfiguration.Builder> insightsConfiguration) {
            return insightsConfiguration(InsightsConfiguration.builder().applyMutation(insightsConfiguration).build());
        }

        /**
         * <p>
         * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information
         * about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of user-applied tags per resource: 50
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag key length: 128 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag value length: 256 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more
         *        information about ways to use tags, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of user-applied tags per resource: 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum tag key length: 128 Unicode characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum tag value length: 256 Unicode characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information
         * about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of user-applied tags per resource: 50
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag key length: 128 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag value length: 256 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more
         *        information about ways to use tags, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference</i>.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of user-applied tags per resource: 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum tag key length: 128 Unicode characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum tag value length: 256 Unicode characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A map that contains one or more tag keys and tag values to attach to an X-Ray group. For more information
         * about ways to use tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging
         * Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of user-applied tags per resource: 50
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag key length: 128 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum tag value length: 256 Unicode characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Valid values for key and value: a-z, A-Z, 0-9, space, and the following characters: _ . : / = + - and @
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Don't use <code>aws:</code> as a prefix for keys; it's reserved for Amazon Web Services use.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.xray.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.xray.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.xray.model.Tag.Builder#build()}
         * is called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.xray.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String groupName;

        private String filterExpression;

        private InsightsConfiguration insightsConfiguration;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            filterExpression(model.filterExpression);
            insightsConfiguration(model.insightsConfiguration);
            tags(model.tags);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final InsightsConfiguration.Builder getInsightsConfiguration() {
            return insightsConfiguration != null ? insightsConfiguration.toBuilder() : null;
        }

        public final void setInsightsConfiguration(InsightsConfiguration.BuilderImpl insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration != null ? insightsConfiguration.build() : null;
        }

        @Override
        public final Builder insightsConfiguration(InsightsConfiguration insightsConfiguration) {
            this.insightsConfiguration = insightsConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
