/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.xray.model.BatchGetTracesRequest;
import software.amazon.awssdk.services.xray.model.BatchGetTracesResponse;
import software.amazon.awssdk.services.xray.model.CreateGroupRequest;
import software.amazon.awssdk.services.xray.model.CreateGroupResponse;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.CreateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.DeleteGroupRequest;
import software.amazon.awssdk.services.xray.model.DeleteGroupResponse;
import software.amazon.awssdk.services.xray.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.xray.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.DeleteSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.GetGroupRequest;
import software.amazon.awssdk.services.xray.model.GetGroupResponse;
import software.amazon.awssdk.services.xray.model.GetGroupsRequest;
import software.amazon.awssdk.services.xray.model.GetGroupsResponse;
import software.amazon.awssdk.services.xray.model.GetInsightEventsRequest;
import software.amazon.awssdk.services.xray.model.GetInsightEventsResponse;
import software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest;
import software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse;
import software.amazon.awssdk.services.xray.model.GetInsightRequest;
import software.amazon.awssdk.services.xray.model.GetInsightResponse;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest;
import software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest;
import software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse;
import software.amazon.awssdk.services.xray.model.GetTraceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetTraceGraphResponse;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.InvalidPolicyRevisionIdException;
import software.amazon.awssdk.services.xray.model.InvalidRequestException;
import software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest;
import software.amazon.awssdk.services.xray.model.ListResourcePoliciesResponse;
import software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.xray.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.xray.model.LockoutPreventionException;
import software.amazon.awssdk.services.xray.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.xray.model.PolicyCountLimitExceededException;
import software.amazon.awssdk.services.xray.model.PolicySizeLimitExceededException;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest;
import software.amazon.awssdk.services.xray.model.PutEncryptionConfigResponse;
import software.amazon.awssdk.services.xray.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.xray.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest;
import software.amazon.awssdk.services.xray.model.PutTelemetryRecordsResponse;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest;
import software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse;
import software.amazon.awssdk.services.xray.model.ResourceNotFoundException;
import software.amazon.awssdk.services.xray.model.RuleLimitExceededException;
import software.amazon.awssdk.services.xray.model.TagResourceRequest;
import software.amazon.awssdk.services.xray.model.TagResourceResponse;
import software.amazon.awssdk.services.xray.model.ThrottledException;
import software.amazon.awssdk.services.xray.model.TooManyTagsException;
import software.amazon.awssdk.services.xray.model.UntagResourceRequest;
import software.amazon.awssdk.services.xray.model.UntagResourceResponse;
import software.amazon.awssdk.services.xray.model.UpdateGroupRequest;
import software.amazon.awssdk.services.xray.model.UpdateGroupResponse;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest;
import software.amazon.awssdk.services.xray.model.UpdateSamplingRuleResponse;
import software.amazon.awssdk.services.xray.model.XRayException;
import software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable;
import software.amazon.awssdk.services.xray.paginators.GetGroupsIterable;
import software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable;
import software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable;
import software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable;
import software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable;
import software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable;
import software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable;
import software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable;
import software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable;
import software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable;
import software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing AWS X-Ray. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services X-Ray provides APIs for managing debug traces and retrieving service maps and other data created
 * by processing those traces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface XRayClient extends AwsClient {
    String SERVICE_NAME = "xray";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "xray";

    /**
     * <p>
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from
     * a single request. Use <code>GetTraceSummaries</code> to get a list of trace IDs.
     * </p>
     *
     * @param batchGetTracesRequest
     * @return Result of the BatchGetTraces operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.BatchGetTraces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTracesResponse batchGetTraces(BatchGetTracesRequest batchGetTracesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from
     * a single request. Use <code>GetTraceSummaries</code> to get a list of trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTracesRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetTracesRequest#builder()}
     * </p>
     *
     * @param batchGetTracesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.BatchGetTracesRequest.Builder} to create a request.
     * @return Result of the BatchGetTraces operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.BatchGetTraces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTracesResponse batchGetTraces(Consumer<BatchGetTracesRequest.Builder> batchGetTracesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return batchGetTraces(BatchGetTracesRequest.builder().applyMutation(batchGetTracesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from
     * a single request. Use <code>GetTraceSummaries</code> to get a list of trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #batchGetTraces(software.amazon.awssdk.services.xray.model.BatchGetTracesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.BatchGetTracesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetTraces(software.amazon.awssdk.services.xray.model.BatchGetTracesRequest)} operation.</b>
     * </p>
     *
     * @param batchGetTracesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.BatchGetTraces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTracesIterable batchGetTracesPaginator(BatchGetTracesRequest batchGetTracesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new BatchGetTracesIterable(this, batchGetTracesRequest);
    }

    /**
     * <p>
     * Retrieves a list of traces specified by ID. Each trace is a collection of segment documents that originates from
     * a single request. Use <code>GetTraceSummaries</code> to get a list of trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #batchGetTraces(software.amazon.awssdk.services.xray.model.BatchGetTracesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.BatchGetTracesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.BatchGetTracesIterable responses = client.batchGetTracesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #batchGetTraces(software.amazon.awssdk.services.xray.model.BatchGetTracesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTracesRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetTracesRequest#builder()}
     * </p>
     *
     * @param batchGetTracesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.BatchGetTracesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.BatchGetTraces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/BatchGetTraces" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchGetTracesIterable batchGetTracesPaginator(Consumer<BatchGetTracesRequest.Builder> batchGetTracesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return batchGetTracesPaginator(BatchGetTracesRequest.builder().applyMutation(batchGetTracesRequest).build());
    }

    /**
     * <p>
     * Creates a group resource with a name and a filter expression.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group resource with a name and a filter expression.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.CreateGroupRequest.Builder} to create a request.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with <a
     * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a>, and evaluate
     * each rule in ascending order of <i>priority</i> for each request. If a rule matches, the service records a trace,
     * borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with <a
     * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> to get
     * updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of
     * borrowing from the reservoir.
     * </p>
     *
     * @param createSamplingRuleRequest
     * @return Result of the CreateSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws RuleLimitExceededException
     *         You have reached the maximum number of sampling rules.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.CreateSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSamplingRuleResponse createSamplingRule(CreateSamplingRuleRequest createSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, RuleLimitExceededException, AwsServiceException,
            SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule to control sampling behavior for instrumented applications. Services retrieve rules with <a
     * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingRules.html">GetSamplingRules</a>, and evaluate
     * each rule in ascending order of <i>priority</i> for each request. If a rule matches, the service records a trace,
     * borrowing it from the reservoir size. After 10 seconds, the service reports back to X-Ray with <a
     * href="https://docs.aws.amazon.com/xray/latest/api/API_GetSamplingTargets.html">GetSamplingTargets</a> to get
     * updated versions of each in-use rule. The updated rule contains a trace quota that the service can use instead of
     * borrowing from the reservoir.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSamplingRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSamplingRuleRequest#builder()}
     * </p>
     *
     * @param createSamplingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.CreateSamplingRuleRequest.Builder} to create a request.
     * @return Result of the CreateSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws RuleLimitExceededException
     *         You have reached the maximum number of sampling rules.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.CreateSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/CreateSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSamplingRuleResponse createSamplingRule(Consumer<CreateSamplingRuleRequest.Builder> createSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, RuleLimitExceededException, AwsServiceException,
            SdkClientException, XRayException {
        return createSamplingRule(CreateSamplingRuleRequest.builder().applyMutation(createSamplingRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a group resource.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a resource policy from the target Amazon Web Services account.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws InvalidPolicyRevisionIdException
     *         A policy revision id was provided which does not match the latest policy revision. This exception is also
     *         if a policy revision id of 0 is provided via <code>PutResourcePolicy</code> and a policy with the same
     *         name already exists.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidRequestException, InvalidPolicyRevisionIdException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource policy from the target Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws InvalidPolicyRevisionIdException
     *         A policy revision id was provided which does not match the latest policy revision. This exception is also
     *         if a policy revision id of 0 is provided via <code>PutResourcePolicy</code> and a policy with the same
     *         name already exists.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws InvalidRequestException,
            InvalidPolicyRevisionIdException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a sampling rule.
     * </p>
     *
     * @param deleteSamplingRuleRequest
     * @return Result of the DeleteSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSamplingRuleResponse deleteSamplingRule(DeleteSamplingRuleRequest deleteSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a sampling rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSamplingRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSamplingRuleRequest#builder()}
     * </p>
     *
     * @param deleteSamplingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.DeleteSamplingRuleRequest.Builder} to create a request.
     * @return Result of the DeleteSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.DeleteSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/DeleteSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSamplingRuleResponse deleteSamplingRule(Consumer<DeleteSamplingRuleRequest.Builder> deleteSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return deleteSamplingRule(DeleteSamplingRuleRequest.builder().applyMutation(deleteSamplingRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves the current encryption configuration for X-Ray data.
     * </p>
     *
     * @param getEncryptionConfigRequest
     * @return Result of the GetEncryptionConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEncryptionConfigResponse getEncryptionConfig(GetEncryptionConfigRequest getEncryptionConfigRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current encryption configuration for X-Ray data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEncryptionConfigRequest.Builder} avoiding the
     * need to create one manually via {@link GetEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param getEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetEncryptionConfigRequest.Builder} to create a request.
     * @return Result of the GetEncryptionConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEncryptionConfigResponse getEncryptionConfig(
            Consumer<GetEncryptionConfigRequest.Builder> getEncryptionConfigRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getEncryptionConfig(GetEncryptionConfigRequest.builder().applyMutation(getEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Retrieves the current encryption configuration for X-Ray data.
     * </p>
     *
     * @return Result of the GetEncryptionConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetEncryptionConfig
     * @see #getEncryptionConfig(GetEncryptionConfigRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetEncryptionConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEncryptionConfigResponse getEncryptionConfig() throws InvalidRequestException, ThrottledException,
            AwsServiceException, SdkClientException, XRayException {
        return getEncryptionConfig(GetEncryptionConfigRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves group resource details.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws InvalidRequestException, ThrottledException,
            AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves group resource details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetGroupRequest.Builder} to create a request.
     * @return Result of the GetGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupResponse getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     *
     * @param getGroupsRequest
     * @return Result of the GetGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsResponse getGroups(GetGroupsRequest getGroupsRequest) throws InvalidRequestException, ThrottledException,
            AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupsRequest#builder()}
     * </p>
     *
     * @param getGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetGroupsRequest.Builder} to create a request.
     * @return Result of the GetGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsResponse getGroups(Consumer<GetGroupsRequest.Builder> getGroupsRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getGroups(GetGroupsRequest.builder().applyMutation(getGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     *
     * @return Result of the GetGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see #getGroups(GetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsResponse getGroups() throws InvalidRequestException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        return getGroups(GetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see #getGroupsPaginator(GetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsIterable getGroupsPaginator() throws InvalidRequestException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        return getGroupsPaginator(GetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.</b>
     * </p>
     *
     * @param getGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsIterable getGroupsPaginator(GetGroupsRequest getGroupsRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetGroupsIterable(this, getGroupsRequest);
    }

    /**
     * <p>
     * Retrieves all active group details.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetGroupsIterable responses = client.getGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroups(software.amazon.awssdk.services.xray.model.GetGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupsRequest#builder()}
     * </p>
     *
     * @param getGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGroupsIterable getGroupsPaginator(Consumer<GetGroupsRequest.Builder> getGroupsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getGroupsPaginator(GetGroupsRequest.builder().applyMutation(getGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top
     * anomalous services, the category, the state of the insight, and the start and end time of the insight.
     * </p>
     *
     * @param getInsightRequest
     * @return Result of the GetInsight operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightResponse getInsight(GetInsightRequest getInsightRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the summary information of an insight. This includes impact to clients and root cause services, the top
     * anomalous services, the category, the state of the insight, and the start and end time of the insight.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightRequest#builder()}
     * </p>
     *
     * @param getInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightRequest.Builder} to create a request.
     * @return Result of the GetInsight operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightResponse getInsight(Consumer<GetInsightRequest.Builder> getInsightRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsight(GetInsightRequest.builder().applyMutation(getInsightRequest).build());
    }

    /**
     * <p>
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event.
     * You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     * </p>
     *
     * @param getInsightEventsRequest
     * @return Result of the GetInsightEvents operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightEventsResponse getInsightEvents(GetInsightEventsRequest getInsightEventsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event.
     * You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightEventsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightEventsRequest#builder()}
     * </p>
     *
     * @param getInsightEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightEventsRequest.Builder} to create a request.
     * @return Result of the GetInsightEvents operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightEventsResponse getInsightEvents(Consumer<GetInsightEventsRequest.Builder> getInsightEventsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsightEvents(GetInsightEventsRequest.builder().applyMutation(getInsightEventsRequest).build());
    }

    /**
     * <p>
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event.
     * You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInsightEvents(software.amazon.awssdk.services.xray.model.GetInsightEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client.getInsightEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client
     *             .getInsightEventsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetInsightEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client.getInsightEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsightEvents(software.amazon.awssdk.services.xray.model.GetInsightEventsRequest)} operation.</b>
     * </p>
     *
     * @param getInsightEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightEventsIterable getInsightEventsPaginator(GetInsightEventsRequest getInsightEventsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetInsightEventsIterable(this, getInsightEventsRequest);
    }

    /**
     * <p>
     * X-Ray reevaluates insights periodically until they're resolved, and records each intermediate state as an event.
     * You can review an insight's events in the Impact Timeline on the Inspect page in the X-Ray console.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInsightEvents(software.amazon.awssdk.services.xray.model.GetInsightEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client.getInsightEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client
     *             .getInsightEventsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetInsightEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightEventsIterable responses = client.getInsightEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsightEvents(software.amazon.awssdk.services.xray.model.GetInsightEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightEventsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightEventsRequest#builder()}
     * </p>
     *
     * @param getInsightEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightEventsIterable getInsightEventsPaginator(Consumer<GetInsightEventsRequest.Builder> getInsightEventsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsightEventsPaginator(GetInsightEventsRequest.builder().applyMutation(getInsightEventsRequest).build());
    }

    /**
     * <p>
     * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only
     * structural information. For a complete service graph, use this API with the GetServiceGraph API.
     * </p>
     *
     * @param getInsightImpactGraphRequest
     * @return Result of the GetInsightImpactGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightImpactGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightImpactGraph" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightImpactGraphResponse getInsightImpactGraph(GetInsightImpactGraphRequest getInsightImpactGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a service graph structure filtered by the specified insight. The service graph is limited to only
     * structural information. For a complete service graph, use this API with the GetServiceGraph API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightImpactGraphRequest.Builder} avoiding the
     * need to create one manually via {@link GetInsightImpactGraphRequest#builder()}
     * </p>
     *
     * @param getInsightImpactGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest.Builder} to create a
     *        request.
     * @return Result of the GetInsightImpactGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightImpactGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightImpactGraph" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightImpactGraphResponse getInsightImpactGraph(
            Consumer<GetInsightImpactGraphRequest.Builder> getInsightImpactGraphRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsightImpactGraph(GetInsightImpactGraphRequest.builder().applyMutation(getInsightImpactGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     * </p>
     *
     * @param getInsightSummariesRequest
     * @return Result of the GetInsightSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightSummariesResponse getInsightSummaries(GetInsightSummariesRequest getInsightSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link GetInsightSummariesRequest#builder()}
     * </p>
     *
     * @param getInsightSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest.Builder} to create a request.
     * @return Result of the GetInsightSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightSummariesResponse getInsightSummaries(
            Consumer<GetInsightSummariesRequest.Builder> getInsightSummariesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsightSummaries(GetInsightSummariesRequest.builder().applyMutation(getInsightSummariesRequest).build());
    }

    /**
     * <p>
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInsightSummaries(software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client.getInsightSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client
     *             .getInsightSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client.getInsightSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsightSummaries(software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getInsightSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightSummariesIterable getInsightSummariesPaginator(GetInsightSummariesRequest getInsightSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetInsightSummariesIterable(this, getInsightSummariesRequest);
    }

    /**
     * <p>
     * Retrieves the summaries of all insights in the specified group matching the provided filter values.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInsightSummaries(software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client.getInsightSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client
     *             .getInsightSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetInsightSummariesIterable responses = client.getInsightSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsightSummaries(software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightSummariesRequest.Builder} avoiding the
     * need to create one manually via {@link GetInsightSummariesRequest#builder()}
     * </p>
     *
     * @param getInsightSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetInsightSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetInsightSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightSummariesIterable getInsightSummariesPaginator(
            Consumer<GetInsightSummariesRequest.Builder> getInsightSummariesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getInsightSummariesPaginator(GetInsightSummariesRequest.builder().applyMutation(getInsightSummariesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     *
     * @param getSamplingRulesRequest
     * @return Result of the GetSamplingRules operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesResponse getSamplingRules(GetSamplingRulesRequest getSamplingRulesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamplingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link GetSamplingRulesRequest#builder()}
     * </p>
     *
     * @param getSamplingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest.Builder} to create a request.
     * @return Result of the GetSamplingRules operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesResponse getSamplingRules(Consumer<GetSamplingRulesRequest.Builder> getSamplingRulesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingRules(GetSamplingRulesRequest.builder().applyMutation(getSamplingRulesRequest).build());
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     *
     * @return Result of the GetSamplingRules operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see #getSamplingRules(GetSamplingRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesResponse getSamplingRules() throws InvalidRequestException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        return getSamplingRules(GetSamplingRulesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client
     *             .getSamplingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see #getSamplingRulesPaginator(GetSamplingRulesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesIterable getSamplingRulesPaginator() throws InvalidRequestException, ThrottledException,
            AwsServiceException, SdkClientException, XRayException {
        return getSamplingRulesPaginator(GetSamplingRulesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client
     *             .getSamplingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation.</b>
     * </p>
     *
     * @param getSamplingRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesIterable getSamplingRulesPaginator(GetSamplingRulesRequest getSamplingRulesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetSamplingRulesIterable(this, getSamplingRulesRequest);
    }

    /**
     * <p>
     * Retrieves all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client
     *             .getSamplingRulesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingRulesIterable responses = client.getSamplingRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingRules(software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamplingRulesRequest.Builder} avoiding the need
     * to create one manually via {@link GetSamplingRulesRequest#builder()}
     * </p>
     *
     * @param getSamplingRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingRulesIterable getSamplingRulesPaginator(Consumer<GetSamplingRulesRequest.Builder> getSamplingRulesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingRulesPaginator(GetSamplingRulesRequest.builder().applyMutation(getSamplingRulesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     *
     * @param getSamplingStatisticSummariesRequest
     * @return Result of the GetSamplingStatisticSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesResponse getSamplingStatisticSummaries(
            GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamplingStatisticSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link GetSamplingStatisticSummariesRequest#builder()}
     * </p>
     *
     * @param getSamplingStatisticSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest.Builder} to create
     *        a request.
     * @return Result of the GetSamplingStatisticSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesResponse getSamplingStatisticSummaries(
            Consumer<GetSamplingStatisticSummariesRequest.Builder> getSamplingStatisticSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest.builder()
                .applyMutation(getSamplingStatisticSummariesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     *
     * @return Result of the GetSamplingStatisticSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see #getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesResponse getSamplingStatisticSummaries() throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingStatisticSummaries(GetSamplingStatisticSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client
     *             .getSamplingStatisticSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see #getSamplingStatisticSummariesPaginator(GetSamplingStatisticSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesIterable getSamplingStatisticSummariesPaginator() throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingStatisticSummariesPaginator(GetSamplingStatisticSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client
     *             .getSamplingStatisticSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSamplingStatisticSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesIterable getSamplingStatisticSummariesPaginator(
            GetSamplingStatisticSummariesRequest getSamplingStatisticSummariesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetSamplingStatisticSummariesIterable(this, getSamplingStatisticSummariesRequest);
    }

    /**
     * <p>
     * Retrieves information about recent sampling results for all sampling rules.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client
     *             .getSamplingStatisticSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetSamplingStatisticSummariesIterable responses = client.getSamplingStatisticSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSamplingStatisticSummaries(software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamplingStatisticSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link GetSamplingStatisticSummariesRequest#builder()}
     * </p>
     *
     * @param getSamplingStatisticSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingStatisticSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingStatisticSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSamplingStatisticSummariesIterable getSamplingStatisticSummariesPaginator(
            Consumer<GetSamplingStatisticSummariesRequest.Builder> getSamplingStatisticSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingStatisticSummariesPaginator(GetSamplingStatisticSummariesRequest.builder()
                .applyMutation(getSamplingStatisticSummariesRequest).build());
    }

    /**
     * <p>
     * Requests a sampling quota for rules that the service is using to sample requests.
     * </p>
     *
     * @param getSamplingTargetsRequest
     * @return Result of the GetSamplingTargets operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingTargetsResponse getSamplingTargets(GetSamplingTargetsRequest getSamplingTargetsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a sampling quota for rules that the service is using to sample requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSamplingTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSamplingTargetsRequest#builder()}
     * </p>
     *
     * @param getSamplingTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetSamplingTargetsRequest.Builder} to create a request.
     * @return Result of the GetSamplingTargets operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetSamplingTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetSamplingTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSamplingTargetsResponse getSamplingTargets(Consumer<GetSamplingTargetsRequest.Builder> getSamplingTargetsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getSamplingTargets(GetSamplingTargetsRequest.builder().applyMutation(getSamplingTargetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a document that describes services that process incoming requests, and downstream services that they
     * call as a result. Root services process incoming requests and make calls to downstream services. Root services
     * are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray
     * SDK</a>. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL
     * databases.
     * </p>
     *
     * @param getServiceGraphRequest
     * @return Result of the GetServiceGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetServiceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceGraphResponse getServiceGraph(GetServiceGraphRequest getServiceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a document that describes services that process incoming requests, and downstream services that they
     * call as a result. Root services process incoming requests and make calls to downstream services. Root services
     * are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray
     * SDK</a>. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL
     * databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceGraphRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceGraphRequest#builder()}
     * </p>
     *
     * @param getServiceGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetServiceGraphRequest.Builder} to create a request.
     * @return Result of the GetServiceGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetServiceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceGraphResponse getServiceGraph(Consumer<GetServiceGraphRequest.Builder> getServiceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getServiceGraph(GetServiceGraphRequest.builder().applyMutation(getServiceGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves a document that describes services that process incoming requests, and downstream services that they
     * call as a result. Root services process incoming requests and make calls to downstream services. Root services
     * are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray
     * SDK</a>. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL
     * databases.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getServiceGraph(software.amazon.awssdk.services.xray.model.GetServiceGraphRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetServiceGraphResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServiceGraph(software.amazon.awssdk.services.xray.model.GetServiceGraphRequest)} operation.</b>
     * </p>
     *
     * @param getServiceGraphRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetServiceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceGraphIterable getServiceGraphPaginator(GetServiceGraphRequest getServiceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetServiceGraphIterable(this, getServiceGraphRequest);
    }

    /**
     * <p>
     * Retrieves a document that describes services that process incoming requests, and downstream services that they
     * call as a result. Root services process incoming requests and make calls to downstream services. Root services
     * are applications that use the <a href="https://docs.aws.amazon.com/xray/index.html">Amazon Web Services X-Ray
     * SDK</a>. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL
     * databases.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getServiceGraph(software.amazon.awssdk.services.xray.model.GetServiceGraphRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetServiceGraphResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetServiceGraphIterable responses = client.getServiceGraphPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getServiceGraph(software.amazon.awssdk.services.xray.model.GetServiceGraphRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceGraphRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceGraphRequest#builder()}
     * </p>
     *
     * @param getServiceGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetServiceGraphRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetServiceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetServiceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceGraphIterable getServiceGraphPaginator(Consumer<GetServiceGraphRequest.Builder> getServiceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getServiceGraphPaginator(GetServiceGraphRequest.builder().applyMutation(getServiceGraphRequest).build());
    }

    /**
     * <p>
     * Get an aggregation of service statistics defined by a specific time range.
     * </p>
     *
     * @param getTimeSeriesServiceStatisticsRequest
     * @return Result of the GetTimeSeriesServiceStatistics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTimeSeriesServiceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesServiceStatisticsResponse getTimeSeriesServiceStatistics(
            GetTimeSeriesServiceStatisticsRequest getTimeSeriesServiceStatisticsRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get an aggregation of service statistics defined by a specific time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimeSeriesServiceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTimeSeriesServiceStatisticsRequest#builder()}
     * </p>
     *
     * @param getTimeSeriesServiceStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the GetTimeSeriesServiceStatistics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTimeSeriesServiceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesServiceStatisticsResponse getTimeSeriesServiceStatistics(
            Consumer<GetTimeSeriesServiceStatisticsRequest.Builder> getTimeSeriesServiceStatisticsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTimeSeriesServiceStatistics(GetTimeSeriesServiceStatisticsRequest.builder()
                .applyMutation(getTimeSeriesServiceStatisticsRequest).build());
    }

    /**
     * <p>
     * Get an aggregation of service statistics defined by a specific time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTimeSeriesServiceStatistics(software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client.getTimeSeriesServiceStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client
     *             .getTimeSeriesServiceStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client.getTimeSeriesServiceStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTimeSeriesServiceStatistics(software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getTimeSeriesServiceStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTimeSeriesServiceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesServiceStatisticsIterable getTimeSeriesServiceStatisticsPaginator(
            GetTimeSeriesServiceStatisticsRequest getTimeSeriesServiceStatisticsRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetTimeSeriesServiceStatisticsIterable(this, getTimeSeriesServiceStatisticsRequest);
    }

    /**
     * <p>
     * Get an aggregation of service statistics defined by a specific time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTimeSeriesServiceStatistics(software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client.getTimeSeriesServiceStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client
     *             .getTimeSeriesServiceStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTimeSeriesServiceStatisticsIterable responses = client.getTimeSeriesServiceStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTimeSeriesServiceStatistics(software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimeSeriesServiceStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link GetTimeSeriesServiceStatisticsRequest#builder()}
     * </p>
     *
     * @param getTimeSeriesServiceStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTimeSeriesServiceStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTimeSeriesServiceStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimeSeriesServiceStatisticsIterable getTimeSeriesServiceStatisticsPaginator(
            Consumer<GetTimeSeriesServiceStatisticsRequest.Builder> getTimeSeriesServiceStatisticsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTimeSeriesServiceStatisticsPaginator(GetTimeSeriesServiceStatisticsRequest.builder()
                .applyMutation(getTimeSeriesServiceStatisticsRequest).build());
    }

    /**
     * <p>
     * Retrieves a service graph for one or more specific trace IDs.
     * </p>
     *
     * @param getTraceGraphRequest
     * @return Result of the GetTraceGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceGraphResponse getTraceGraph(GetTraceGraphRequest getTraceGraphRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a service graph for one or more specific trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTraceGraphRequest.Builder} avoiding the need to
     * create one manually via {@link GetTraceGraphRequest#builder()}
     * </p>
     *
     * @param getTraceGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTraceGraphRequest.Builder} to create a request.
     * @return Result of the GetTraceGraph operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceGraphResponse getTraceGraph(Consumer<GetTraceGraphRequest.Builder> getTraceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTraceGraph(GetTraceGraphRequest.builder().applyMutation(getTraceGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves a service graph for one or more specific trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTraceGraph(software.amazon.awssdk.services.xray.model.GetTraceGraphRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTraceGraphResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTraceGraph(software.amazon.awssdk.services.xray.model.GetTraceGraphRequest)} operation.</b>
     * </p>
     *
     * @param getTraceGraphRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceGraphIterable getTraceGraphPaginator(GetTraceGraphRequest getTraceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetTraceGraphIterable(this, getTraceGraphRequest);
    }

    /**
     * <p>
     * Retrieves a service graph for one or more specific trace IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getTraceGraph(software.amazon.awssdk.services.xray.model.GetTraceGraphRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTraceGraphResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceGraphIterable responses = client.getTraceGraphPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTraceGraph(software.amazon.awssdk.services.xray.model.GetTraceGraphRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTraceGraphRequest.Builder} avoiding the need to
     * create one manually via {@link GetTraceGraphRequest#builder()}
     * </p>
     *
     * @param getTraceGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTraceGraphRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceGraphIterable getTraceGraphPaginator(Consumer<GetTraceGraphRequest.Builder> getTraceGraphRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTraceGraphPaginator(GetTraceGraphRequest.builder().applyMutation(getTraceGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get
     * the full traces, pass the trace IDs to <code>BatchGetTraces</code>.
     * </p>
     * <p>
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come
     * from a known user. For example, the following filter expression targets traces that pass through
     * <code>api.example.com</code>:
     * </p>
     * <p>
     * <code>service("api.example.com")</code>
     * </p>
     * <p>
     * This filter expression finds traces that have an annotation named <code>account</code> with the value
     * <code>12345</code>:
     * </p>
     * <p>
     * <code>annotation.account = "12345"</code>
     * </p>
     * <p>
     * For a full list of indexed fields and keywords that you can use in filter expressions, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter Expressions</a> in
     * the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     *
     * @param getTraceSummariesRequest
     * @return Result of the GetTraceSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceSummariesResponse getTraceSummaries(GetTraceSummariesRequest getTraceSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get
     * the full traces, pass the trace IDs to <code>BatchGetTraces</code>.
     * </p>
     * <p>
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come
     * from a known user. For example, the following filter expression targets traces that pass through
     * <code>api.example.com</code>:
     * </p>
     * <p>
     * <code>service("api.example.com")</code>
     * </p>
     * <p>
     * This filter expression finds traces that have an annotation named <code>account</code> with the value
     * <code>12345</code>:
     * </p>
     * <p>
     * <code>annotation.account = "12345"</code>
     * </p>
     * <p>
     * For a full list of indexed fields and keywords that you can use in filter expressions, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter Expressions</a> in
     * the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTraceSummariesRequest.Builder} avoiding the need
     * to create one manually via {@link GetTraceSummariesRequest#builder()}
     * </p>
     *
     * @param getTraceSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest.Builder} to create a request.
     * @return Result of the GetTraceSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceSummariesResponse getTraceSummaries(Consumer<GetTraceSummariesRequest.Builder> getTraceSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTraceSummaries(GetTraceSummariesRequest.builder().applyMutation(getTraceSummariesRequest).build());
    }

    /**
     * <p>
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get
     * the full traces, pass the trace IDs to <code>BatchGetTraces</code>.
     * </p>
     * <p>
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come
     * from a known user. For example, the following filter expression targets traces that pass through
     * <code>api.example.com</code>:
     * </p>
     * <p>
     * <code>service("api.example.com")</code>
     * </p>
     * <p>
     * This filter expression finds traces that have an annotation named <code>account</code> with the value
     * <code>12345</code>:
     * </p>
     * <p>
     * <code>annotation.account = "12345"</code>
     * </p>
     * <p>
     * For a full list of indexed fields and keywords that you can use in filter expressions, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter Expressions</a> in
     * the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTraceSummaries(software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client.getTraceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client
     *             .getTraceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client.getTraceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTraceSummaries(software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest)} operation.</b>
     * </p>
     *
     * @param getTraceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceSummariesIterable getTraceSummariesPaginator(GetTraceSummariesRequest getTraceSummariesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new GetTraceSummariesIterable(this, getTraceSummariesRequest);
    }

    /**
     * <p>
     * Retrieves IDs and annotations for traces available for a specified time frame using an optional filter. To get
     * the full traces, pass the trace IDs to <code>BatchGetTraces</code>.
     * </p>
     * <p>
     * A filter expression can target traced requests that hit specific service nodes or edges, have errors, or come
     * from a known user. For example, the following filter expression targets traces that pass through
     * <code>api.example.com</code>:
     * </p>
     * <p>
     * <code>service("api.example.com")</code>
     * </p>
     * <p>
     * This filter expression finds traces that have an annotation named <code>account</code> with the value
     * <code>12345</code>:
     * </p>
     * <p>
     * <code>annotation.account = "12345"</code>
     * </p>
     * <p>
     * For a full list of indexed fields and keywords that you can use in filter expressions, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html">Using Filter Expressions</a> in
     * the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getTraceSummaries(software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client.getTraceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client
     *             .getTraceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.GetTraceSummariesIterable responses = client.getTraceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getTraceSummaries(software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTraceSummariesRequest.Builder} avoiding the need
     * to create one manually via {@link GetTraceSummariesRequest#builder()}
     * </p>
     *
     * @param getTraceSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.GetTraceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/GetTraceSummaries" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTraceSummariesIterable getTraceSummariesPaginator(
            Consumer<GetTraceSummariesRequest.Builder> getTraceSummariesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return getTraceSummariesPaginator(GetTraceSummariesRequest.builder().applyMutation(getTraceSummariesRequest).build());
    }

    /**
     * <p>
     * Returns the list of resource policies in the target Amazon Web Services account.
     * </p>
     *
     * @param listResourcePoliciesRequest
     * @return Result of the ListResourcePolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesResponse listResourcePolicies(ListResourcePoliciesRequest listResourcePoliciesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of resource policies in the target Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param listResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourcePolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesResponse listResourcePolicies(
            Consumer<ListResourcePoliciesRequest.Builder> listResourcePoliciesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return listResourcePolicies(ListResourcePoliciesRequest.builder().applyMutation(listResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Returns the list of resource policies in the target Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcePolicies(software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client.listResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client
     *             .listResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.ListResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client.listResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcePolicies(software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesIterable listResourcePoliciesPaginator(ListResourcePoliciesRequest listResourcePoliciesRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return new ListResourcePoliciesIterable(this, listResourcePoliciesRequest);
    }

    /**
     * <p>
     * Returns the list of resource policies in the target Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcePolicies(software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client.listResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client
     *             .listResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.ListResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListResourcePoliciesIterable responses = client.listResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcePolicies(software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param listResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.ListResourcePoliciesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListResourcePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcePoliciesIterable listResourcePoliciesPaginator(
            Consumer<ListResourcePoliciesRequest.Builder> listResourcePoliciesRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return listResourcePoliciesPaginator(ListResourcePoliciesRequest.builder().applyMutation(listResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, XRayException {
        return new ListTagsForResourceIterable(this, listTagsForResourceRequest);
    }

    /**
     * <p>
     * Returns a list of tags that are applied to the specified Amazon Web Services X-Ray group or sampling rule.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.xray.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.xray.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Updates the encryption configuration for X-Ray data.
     * </p>
     *
     * @param putEncryptionConfigRequest
     * @return Result of the PutEncryptionConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEncryptionConfigResponse putEncryptionConfig(PutEncryptionConfigRequest putEncryptionConfigRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the encryption configuration for X-Ray data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEncryptionConfigRequest.Builder} avoiding the
     * need to create one manually via {@link PutEncryptionConfigRequest#builder()}
     * </p>
     *
     * @param putEncryptionConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest.Builder} to create a request.
     * @return Result of the PutEncryptionConfig operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutEncryptionConfig" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEncryptionConfigResponse putEncryptionConfig(
            Consumer<PutEncryptionConfigRequest.Builder> putEncryptionConfigRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return putEncryptionConfig(PutEncryptionConfigRequest.builder().applyMutation(putEncryptionConfigRequest).build());
    }

    /**
     * <p>
     * Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access
     * X-Ray. Each resource policy will be associated with a specific Amazon Web Services account. Each Amazon Web
     * Services account can have a maximum of 5 resource policies, and each policy name must be unique within that
     * account. The maximum size of each resource policy is 5KB.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         Invalid policy document provided in request.
     * @throws LockoutPreventionException
     *         The provided resource policy would prevent the caller of this request from calling PutResourcePolicy in
     *         the future.
     * @throws InvalidPolicyRevisionIdException
     *         A policy revision id was provided which does not match the latest policy revision. This exception is also
     *         if a policy revision id of 0 is provided via <code>PutResourcePolicy</code> and a policy with the same
     *         name already exists.
     * @throws PolicySizeLimitExceededException
     *         Exceeded the maximum size for a resource policy.
     * @throws PolicyCountLimitExceededException
     *         Exceeded the maximum number of resource policies for a target Amazon Web Services account.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws MalformedPolicyDocumentException, LockoutPreventionException, InvalidPolicyRevisionIdException,
            PolicySizeLimitExceededException, PolicyCountLimitExceededException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the resource policy to grant one or more Amazon Web Services services and accounts permissions to access
     * X-Ray. Each resource policy will be associated with a specific Amazon Web Services account. Each Amazon Web
     * Services account can have a maximum of 5 resource policies, and each policy name must be unique within that
     * account. The maximum size of each resource policy is 5KB.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.PutResourcePolicyRequest.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws MalformedPolicyDocumentException
     *         Invalid policy document provided in request.
     * @throws LockoutPreventionException
     *         The provided resource policy would prevent the caller of this request from calling PutResourcePolicy in
     *         the future.
     * @throws InvalidPolicyRevisionIdException
     *         A policy revision id was provided which does not match the latest policy revision. This exception is also
     *         if a policy revision id of 0 is provided via <code>PutResourcePolicy</code> and a policy with the same
     *         name already exists.
     * @throws PolicySizeLimitExceededException
     *         Exceeded the maximum size for a resource policy.
     * @throws PolicyCountLimitExceededException
     *         Exceeded the maximum number of resource policies for a target Amazon Web Services account.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws MalformedPolicyDocumentException, LockoutPreventionException, InvalidPolicyRevisionIdException,
            PolicySizeLimitExceededException, PolicyCountLimitExceededException, ThrottledException, AwsServiceException,
            SdkClientException, XRayException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
     * </p>
     *
     * @param putTelemetryRecordsRequest
     * @return Result of the PutTelemetryRecords operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutTelemetryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTelemetryRecordsResponse putTelemetryRecords(PutTelemetryRecordsRequest putTelemetryRecordsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by the Amazon Web Services X-Ray daemon to upload telemetry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTelemetryRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link PutTelemetryRecordsRequest#builder()}
     * </p>
     *
     * @param putTelemetryRecordsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest.Builder} to create a request.
     * @return Result of the PutTelemetryRecords operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutTelemetryRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTelemetryRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTelemetryRecordsResponse putTelemetryRecords(
            Consumer<PutTelemetryRecordsRequest.Builder> putTelemetryRecordsRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return putTelemetryRecords(PutTelemetryRecordsRequest.builder().applyMutation(putTelemetryRecordsRequest).build());
    }

    /**
     * <p>
     * Uploads segment documents to Amazon Web Services X-Ray. The <a
     * href="https://docs.aws.amazon.com/xray/index.html">X-Ray SDK</a> generates segment documents and sends them to
     * the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress
     * segment, or an array of subsegments.
     * </p>
     * <p>
     * Segments must include the following fields. For the full segment document schema, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">Amazon Web Services X-Ray
     * Segment Documents</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     * <p class="title">
     * <b>Required segment document fields</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>name</code> - The name of the service that handled the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>id</code> - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal
     * digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>trace_id</code> - A unique identifier that connects all segments and subsegments originating from a single
     * client request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start_time</code> - Time the segment or subsegment was created, in floating point seconds in epoch time,
     * accurate to milliseconds. For example, <code>1480615200.010</code> or <code>1.480615200010E9</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>end_time</code> - Time the segment or subsegment was closed. For example, <code>1480615200.090</code> or
     * <code>1.480615200090E9</code>. Specify either an <code>end_time</code> or <code>in_progress</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in_progress</code> - Set to <code>true</code> instead of specifying an <code>end_time</code> to record that
     * a segment has been started, but is not complete. Send an in-progress segment when your application receives a
     * request that will take a long time to serve, to trace that the request was received. When the response is sent,
     * send the complete segment to overwrite the in-progress segment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A <code>trace_id</code> consists of three numbers separated by hyphens. For example,
     * 1-58406520-a006649127e371903a2de979. This includes:
     * </p>
     * <p class="title">
     * <b>Trace ID Format</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The version number, for instance, <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd,
     * 2016 PST in epoch time is <code>1480615200</code> seconds, or <code>58406520</code> in hexadecimal.
     * </p>
     * </li>
     * <li>
     * <p>
     * A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
     * </p>
     * </li>
     * </ul>
     *
     * @param putTraceSegmentsRequest
     * @return Result of the PutTraceSegments operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutTraceSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTraceSegmentsResponse putTraceSegments(PutTraceSegmentsRequest putTraceSegmentsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads segment documents to Amazon Web Services X-Ray. The <a
     * href="https://docs.aws.amazon.com/xray/index.html">X-Ray SDK</a> generates segment documents and sends them to
     * the X-Ray daemon, which uploads them in batches. A segment document can be a completed segment, an in-progress
     * segment, or an array of subsegments.
     * </p>
     * <p>
     * Segments must include the following fields. For the full segment document schema, see <a
     * href="https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html">Amazon Web Services X-Ray
     * Segment Documents</a> in the <i>Amazon Web Services X-Ray Developer Guide</i>.
     * </p>
     * <p class="title">
     * <b>Required segment document fields</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>name</code> - The name of the service that handled the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>id</code> - A 64-bit identifier for the segment, unique among segments in the same trace, in 16 hexadecimal
     * digits.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>trace_id</code> - A unique identifier that connects all segments and subsegments originating from a single
     * client request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start_time</code> - Time the segment or subsegment was created, in floating point seconds in epoch time,
     * accurate to milliseconds. For example, <code>1480615200.010</code> or <code>1.480615200010E9</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>end_time</code> - Time the segment or subsegment was closed. For example, <code>1480615200.090</code> or
     * <code>1.480615200090E9</code>. Specify either an <code>end_time</code> or <code>in_progress</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>in_progress</code> - Set to <code>true</code> instead of specifying an <code>end_time</code> to record that
     * a segment has been started, but is not complete. Send an in-progress segment when your application receives a
     * request that will take a long time to serve, to trace that the request was received. When the response is sent,
     * send the complete segment to overwrite the in-progress segment.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A <code>trace_id</code> consists of three numbers separated by hyphens. For example,
     * 1-58406520-a006649127e371903a2de979. This includes:
     * </p>
     * <p class="title">
     * <b>Trace ID Format</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * The version number, for instance, <code>1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The time of the original request, in Unix epoch time, in 8 hexadecimal digits. For example, 10:00AM December 2nd,
     * 2016 PST in epoch time is <code>1480615200</code> seconds, or <code>58406520</code> in hexadecimal.
     * </p>
     * </li>
     * <li>
     * <p>
     * A 96-bit identifier for the trace, globally unique, in 24 hexadecimal digits.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTraceSegmentsRequest.Builder} avoiding the need
     * to create one manually via {@link PutTraceSegmentsRequest#builder()}
     * </p>
     *
     * @param putTraceSegmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest.Builder} to create a request.
     * @return Result of the PutTraceSegments operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.PutTraceSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/PutTraceSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTraceSegmentsResponse putTraceSegments(Consumer<PutTraceSegmentsRequest.Builder> putTraceSegmentsRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return putTraceSegments(PutTraceSegmentsRequest.builder().applyMutation(putTraceSegmentsRequest).build());
    }

    /**
     * <p>
     * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ThrottledException, ResourceNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException,
            XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to an existing Amazon Web Services X-Ray group or sampling rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws TooManyTagsException
     *         You have exceeded the maximum number of tags you can apply to this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, ThrottledException, ResourceNotFoundException, TooManyTagsException,
            AwsServiceException, SdkClientException, XRayException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags
     * (those with an <code>aws:</code> prefix).
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            ThrottledException, ResourceNotFoundException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from an Amazon Web Services X-Ray group or sampling rule. You cannot edit or delete system tags
     * (those with an <code>aws:</code> prefix).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws ResourceNotFoundException
     *         The resource was not found. Verify that the name or Amazon Resource Name (ARN) of the resource is
     *         correct.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, ThrottledException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, XRayException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a group resource.
     * </p>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws InvalidRequestException,
            ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a group resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.UpdateGroupRequest.Builder} to create a request.
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGroupResponse updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Modifies a sampling rule's configuration.
     * </p>
     *
     * @param updateSamplingRuleRequest
     * @return Result of the UpdateSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UpdateSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSamplingRuleResponse updateSamplingRule(UpdateSamplingRuleRequest updateSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies a sampling rule's configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSamplingRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSamplingRuleRequest#builder()}
     * </p>
     *
     * @param updateSamplingRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.xray.model.UpdateSamplingRuleRequest.Builder} to create a request.
     * @return Result of the UpdateSamplingRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is missing required parameters or has invalid parameters.
     * @throws ThrottledException
     *         The request exceeds the maximum number of requests per second.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws XRayException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample XRayClient.UpdateSamplingRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/xray-2016-04-12/UpdateSamplingRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSamplingRuleResponse updateSamplingRule(Consumer<UpdateSamplingRuleRequest.Builder> updateSamplingRuleRequest)
            throws InvalidRequestException, ThrottledException, AwsServiceException, SdkClientException, XRayException {
        return updateSamplingRule(UpdateSamplingRuleRequest.builder().applyMutation(updateSamplingRuleRequest).build());
    }

    /**
     * Create a {@link XRayClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static XRayClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link XRayClient}.
     */
    static XRayClientBuilder builder() {
        return new DefaultXRayClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default XRayServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
