/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.xray.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutResourcePolicyRequest extends XRayRequest implements
        ToCopyableBuilder<PutResourcePolicyRequest.Builder, PutResourcePolicyRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyName").getter(getter(PutResourcePolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument").getter(getter(PutResourcePolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(PutResourcePolicyRequest::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()).build();

    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("BypassPolicyLockoutCheck")
            .getter(getter(PutResourcePolicyRequest::bypassPolicyLockoutCheck)).setter(setter(Builder::bypassPolicyLockoutCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BypassPolicyLockoutCheck").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_DOCUMENT_FIELD, POLICY_REVISION_ID_FIELD, BYPASS_POLICY_LOCKOUT_CHECK_FIELD));

    private final String policyName;

    private final String policyDocument;

    private final String policyRevisionId;

    private final Boolean bypassPolicyLockoutCheck;

    private PutResourcePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.policyRevisionId = builder.policyRevisionId;
        this.bypassPolicyLockoutCheck = builder.bypassPolicyLockoutCheck;
    }

    /**
     * <p>
     * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
     * </p>
     * 
     * @return The name of the resource policy. Must be unique within a specific Amazon Web Services account.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The resource policy document, which can be up to 5kb in size.
     * </p>
     * 
     * @return The resource policy document, which can be up to 5kb in size.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is
     * created if it does not exist, or updated with an incremented revision id. The revision id is unique to each
     * policy in the account.
     * </p>
     * <p>
     * If the policy revision id does not match the latest revision id, the operation will fail with an
     * <code>InvalidPolicyRevisionIdException</code> exception. You can also provide a <code>PolicyRevisionId</code> of
     * 0. In this case, the operation will fail with an <code>InvalidPolicyRevisionIdException</code> exception if a
     * resource policy with the same name already exists.
     * </p>
     * 
     * @return Specifies a specific policy revision, to ensure an atomic create operation. By default the resource
     *         policy is created if it does not exist, or updated with an incremented revision id. The revision id is
     *         unique to each policy in the account.</p>
     *         <p>
     *         If the policy revision id does not match the latest revision id, the operation will fail with an
     *         <code>InvalidPolicyRevisionIdException</code> exception. You can also provide a
     *         <code>PolicyRevisionId</code> of 0. In this case, the operation will fail with an
     *         <code>InvalidPolicyRevisionIdException</code> exception if a resource policy with the same name already
     *         exists.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the resource policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to true
     * indiscriminately.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you include a policy in the request and you intend to prevent the principal that is
     * making the request from making a subsequent <code>PutResourcePolicy</code> request.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return A flag to indicate whether to bypass the resource policy lockout safety check.</p> <important>
     *         <p>
     *         Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value
     *         to true indiscriminately.
     *         </p>
     *         </important>
     *         <p>
     *         Use this parameter only when you include a policy in the request and you intend to prevent the principal
     *         that is making the request from making a subsequent <code>PutResourcePolicy</code> request.
     *         </p>
     *         <p>
     *         The default value is false.
     */
    public final Boolean bypassPolicyLockoutCheck() {
        return bypassPolicyLockoutCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(bypassPolicyLockoutCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutResourcePolicyRequest)) {
            return false;
        }
        PutResourcePolicyRequest other = (PutResourcePolicyRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyRevisionId(), other.policyRevisionId())
                && Objects.equals(bypassPolicyLockoutCheck(), other.bypassPolicyLockoutCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutResourcePolicyRequest").add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).add("PolicyRevisionId", policyRevisionId())
                .add("BypassPolicyLockoutCheck", bypassPolicyLockoutCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        case "BypassPolicyLockoutCheck":
            return Optional.ofNullable(clazz.cast(bypassPolicyLockoutCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutResourcePolicyRequest, T> g) {
        return obj -> g.apply((PutResourcePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends XRayRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutResourcePolicyRequest> {
        /**
         * <p>
         * The name of the resource policy. Must be unique within a specific Amazon Web Services account.
         * </p>
         * 
         * @param policyName
         *        The name of the resource policy. Must be unique within a specific Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The resource policy document, which can be up to 5kb in size.
         * </p>
         * 
         * @param policyDocument
         *        The resource policy document, which can be up to 5kb in size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * Specifies a specific policy revision, to ensure an atomic create operation. By default the resource policy is
         * created if it does not exist, or updated with an incremented revision id. The revision id is unique to each
         * policy in the account.
         * </p>
         * <p>
         * If the policy revision id does not match the latest revision id, the operation will fail with an
         * <code>InvalidPolicyRevisionIdException</code> exception. You can also provide a <code>PolicyRevisionId</code>
         * of 0. In this case, the operation will fail with an <code>InvalidPolicyRevisionIdException</code> exception
         * if a resource policy with the same name already exists.
         * </p>
         * 
         * @param policyRevisionId
         *        Specifies a specific policy revision, to ensure an atomic create operation. By default the resource
         *        policy is created if it does not exist, or updated with an incremented revision id. The revision id is
         *        unique to each policy in the account.</p>
         *        <p>
         *        If the policy revision id does not match the latest revision id, the operation will fail with an
         *        <code>InvalidPolicyRevisionIdException</code> exception. You can also provide a
         *        <code>PolicyRevisionId</code> of 0. In this case, the operation will fail with an
         *        <code>InvalidPolicyRevisionIdException</code> exception if a resource policy with the same name
         *        already exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        /**
         * <p>
         * A flag to indicate whether to bypass the resource policy lockout safety check.
         * </p>
         * <important>
         * <p>
         * Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this value to
         * true indiscriminately.
         * </p>
         * </important>
         * <p>
         * Use this parameter only when you include a policy in the request and you intend to prevent the principal that
         * is making the request from making a subsequent <code>PutResourcePolicy</code> request.
         * </p>
         * <p>
         * The default value is false.
         * </p>
         * 
         * @param bypassPolicyLockoutCheck
         *        A flag to indicate whether to bypass the resource policy lockout safety check.</p> <important>
         *        <p>
         *        Setting this value to true increases the risk that the policy becomes unmanageable. Do not set this
         *        value to true indiscriminately.
         *        </p>
         *        </important>
         *        <p>
         *        Use this parameter only when you include a policy in the request and you intend to prevent the
         *        principal that is making the request from making a subsequent <code>PutResourcePolicy</code> request.
         *        </p>
         *        <p>
         *        The default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutCheck(Boolean bypassPolicyLockoutCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends XRayRequest.BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private String policyRevisionId;

        private Boolean bypassPolicyLockoutCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(PutResourcePolicyRequest model) {
            super(model);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            policyRevisionId(model.policyRevisionId);
            bypassPolicyLockoutCheck(model.bypassPolicyLockoutCheck);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        public final Boolean getBypassPolicyLockoutCheck() {
            return bypassPolicyLockoutCheck;
        }

        public final void setBypassPolicyLockoutCheck(Boolean bypassPolicyLockoutCheck) {
            this.bypassPolicyLockoutCheck = bypassPolicyLockoutCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutCheck(Boolean bypassPolicyLockoutCheck) {
            this.bypassPolicyLockoutCheck = bypassPolicyLockoutCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutResourcePolicyRequest build() {
            return new PutResourcePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
