/*
 * Decompiled with CFR 0.152.
 */
package software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.ConnectionUrl;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertyKey;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.conf.PropertySet;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.IConnectionPlugin;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.ICurrentConnectionProvider;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.NullArgumentMessage;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.DefaultMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.IMonitorService;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.ha.plugins.efm2.MonitorConnectionContext;
import software.aws.rds.jdbc.mysql.shading.com.mysql.cj.log.Log;

public class NodeMonitoringConnectionPlugin
implements IConnectionPlugin {
    private static final String RETRIEVE_HOST_PORT_SQL = "SELECT CONCAT(@@hostname, ':', @@port)";
    private static final Set<String> SKIP_MONITORING_METHODS = new HashSet<String>(Arrays.asList("close", "next", "abort", "closeOnCompletion", "getName", "getVendor", "getVendorTypeNumber", "getBaseTypeName", "getBaseType", "getBinaryStream", "getBytes", "getArray", "getBigDecimal", "getSubString", "getCharacterStream", "getAsciiStream", "getURL", "getUserName", "getDatabaseProductName", "getParameterCount", "getPrecision", "getScale", "getParameterType", "getParameterTypeName", "getParameterClassName", "getConnection", "getFetchDirection", "getFetchSize", "getColumnCount", "getColumnDisplaySize", "getColumnLabel", "getColumnName", "getSchemaName", "getSQLTypeName", "getSavepointId", "getSavepointName", "getMaxFieldSize", "getMaxRows", "getQueryTimeout", "getAttributes", "getString", "getTime", "getTimestamp", "getType", "getUnicodeStream", "getWarnings", "getBinaryStream", "getBlob", "getBoolean", "getByte", "getBytes", "getClob", "getConcurrency", "getDate", "getDouble", "getFloat", "getHoldability", "getInt", "getLong", "getMetaData", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRow", "getRowId", "getSQLXML", "getShort", "getStatement"));
    protected IConnectionPlugin nextPlugin;
    protected Log logger;
    protected PropertySet propertySet;
    private final Supplier<IMonitorService> monitorServiceSupplier;
    private final ICurrentConnectionProvider currentConnectionProvider;
    private IMonitorService monitorService;

    public NodeMonitoringConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger) {
        this(currentConnectionProvider, propertySet, nextPlugin, logger, () -> new DefaultMonitorService(logger));
    }

    NodeMonitoringConnectionPlugin(ICurrentConnectionProvider currentConnectionProvider, PropertySet propertySet, IConnectionPlugin nextPlugin, Log logger, Supplier<IMonitorService> monitorServiceSupplier) {
        this.assertArgumentIsNotNull(currentConnectionProvider, "currentConnectionProvider");
        this.assertArgumentIsNotNull(propertySet, "propertySet");
        this.assertArgumentIsNotNull(nextPlugin, "nextPlugin");
        this.assertArgumentIsNotNull(logger, "logger");
        this.currentConnectionProvider = currentConnectionProvider;
        this.propertySet = propertySet;
        this.logger = logger;
        this.nextPlugin = nextPlugin;
        this.monitorServiceSupplier = monitorServiceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(Class<?> methodInvokeOn, String methodName, Callable<?> executeSqlFunc, Object[] args) throws Exception {
        Object result;
        boolean isEnabled = this.propertySet.getBooleanProperty(PropertyKey.failureDetectionEnabled).getValue();
        if (!isEnabled || !this.doesNeedMonitoring(methodInvokeOn, methodName)) {
            return this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
        }
        int failureDetectionTimeMillis = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionTime).getValue();
        int failureDetectionIntervalMillis = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionInterval).getValue();
        int failureDetectionCount = this.propertySet.getIntegerProperty(PropertyKey.failureDetectionCount).getValue();
        this.initMonitorService();
        MonitorConnectionContext monitorContext = null;
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.logTrace(String.format("[efm2.NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is activated", methodInvokeOn.getName(), methodName));
            }
            monitorContext = this.monitorService.startMonitoring(this.currentConnectionProvider.getCurrentConnection(), this.currentConnectionProvider.getCurrentHostInfo(), this.propertySet, failureDetectionTimeMillis, failureDetectionIntervalMillis, failureDetectionCount);
            result = this.nextPlugin.execute(methodInvokeOn, methodName, executeSqlFunc, args);
            if (monitorContext != null) {
                this.monitorService.stopMonitoring(monitorContext, this.currentConnectionProvider.getCurrentConnection());
            }
            if (!this.logger.isTraceEnabled()) return result;
        }
        catch (Throwable throwable) {
            if (monitorContext != null) {
                this.monitorService.stopMonitoring(monitorContext, this.currentConnectionProvider.getCurrentConnection());
            }
            if (!this.logger.isTraceEnabled()) throw throwable;
            this.logger.logTrace(String.format("[efm2.NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is deactivated", methodInvokeOn.getName(), methodName));
            throw throwable;
        }
        this.logger.logTrace(String.format("[efm2.NodeMonitoringConnectionPlugin.execute]: method=%s.%s, monitoring is deactivated", methodInvokeOn.getName(), methodName));
        return result;
    }

    protected boolean doesNeedMonitoring(Class<?> methodInvokeOn, String methodName) {
        return !SKIP_MONITORING_METHODS.contains(methodName);
    }

    private void initMonitorService() {
        if (this.monitorService == null) {
            this.monitorService = this.monitorServiceSupplier.get();
        }
    }

    @Override
    public void transactionBegun() {
        this.nextPlugin.transactionBegun();
    }

    @Override
    public void transactionCompleted() {
        this.nextPlugin.transactionCompleted();
    }

    @Override
    public void openInitialConnection(ConnectionUrl connectionUrl) throws SQLException {
        this.nextPlugin.openInitialConnection(connectionUrl);
    }

    @Override
    public void releaseResources() {
        if (this.monitorService != null) {
            this.monitorService.releaseResources();
        }
        this.monitorService = null;
        this.nextPlugin.releaseResources();
    }

    private void assertArgumentIsNotNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException(NullArgumentMessage.getMessage(paramName));
        }
    }
}

