/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.encrypt;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

public class Base62Tools {
    private static final char[] BASE62_CHARSETS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static long base62ToLong(String value) {
        long v = 0L;
        if (!Strings.isNullOrEmpty((String)value)) {
            char[] chars = StringUtils.reverse((String)value).toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char asc = chars[i];
                int n = 0;
                if (asc >= '0' && asc <= '9') {
                    n = asc - 48;
                } else if (asc >= 'a' && asc <= 'z') {
                    n = asc - 87;
                } else if (asc >= 'A' && asc <= 'Z') {
                    n = asc - 29;
                }
                v += (long)(Math.pow(BASE62_CHARSETS.length, i) * (double)n);
            }
        }
        return v;
    }

    public static String longToBase62(long num) {
        StringBuilder value = new StringBuilder();
        do {
            int n = (int)(num % (long)BASE62_CHARSETS.length);
            num = (num - (long)n) / (long)BASE62_CHARSETS.length;
            value.append(BASE62_CHARSETS[n]);
        } while (num > 0L);
        return value.reverse().toString();
    }

    public static String longToBase62(String id) {
        try {
            long idLong = Long.valueOf(id);
            return Base62Tools.longToBase62(idLong);
        }
        catch (Exception e) {
            return id;
        }
    }

    public String encode(String code) {
        return code;
    }

    public String decode(String code) {
        return code;
    }
}

