/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.ipdb.api.geoip;

import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import tech.gtt.common.config.config.ConfigTools3;
import tech.gtt.common.ipdb.api.geoip.EGeoIPDBType;

public class GeoIPConfig {
    public static String dbPath() {
        return ConfigTools3.getString("common.ipdb.path", GeoIPConfig.getDefaultPath());
    }

    public static boolean dbAutoUpdate() {
        return ConfigTools3.getBoolean("common.ipdb.update.enable", true);
    }

    public static String dbFilename(EGeoIPDBType type) {
        return String.format("%s/%s", GeoIPConfig.dbPath(), type.getName());
    }

    public static String dbDownloadUrl(EGeoIPDBType type) {
        String key = String.format("common.ipdb.download.%s", type.getType());
        return ConfigTools3.getString(key, GeoIPConfig.getDefaultDownloadUrl(type));
    }

    public static boolean isDbExist(EGeoIPDBType type) {
        String dbFilename = GeoIPConfig.dbFilename(type);
        return Files.exists(Paths.get(dbFilename, new String[0]), new LinkOption[0]) || Files.exists(Paths.get(dbFilename + ".tmp", new String[0]), new LinkOption[0]);
    }

    public static String getFilenameBackup(String fn) {
        return String.format("%s.backup", fn);
    }

    public static String getFilenameUpgrade(String fn) {
        return String.format("%s.upgrade", fn);
    }

    private static String getDefaultDownloadUrl(EGeoIPDBType types) {
        return String.format("https://download.maxmind.com/app/geoip_download?edition_id=%s&license_key=b9uDk6Ou3z94frix&suffix=tar.gz", types.getType());
    }

    public static int updateDuration() {
        return ConfigTools3.getInt("common.ipdb.update.duration", 10080);
    }

    public static String getDBDownloadFilename(EGeoIPDBType types) {
        return String.format("%s/new-%s.tar.gz", GeoIPConfig.dbPath(), types.getType());
    }

    public static String getDefaultPath() {
        String path = FileUtils.getUserDirectoryPath();
        if (Strings.isNullOrEmpty((String)path)) {
            return "./.valor/ipdb";
        }
        return path + "/.valor/ipdb";
    }

    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return !Strings.isNullOrEmpty((String)osName) && osName.contains("window");
    }
}

