/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.JSON;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class GsonTypeAdapter
extends TypeAdapter<Object> {
    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                double dbNum = in.nextDouble();
                if (dbNum > 9.223372036854776E18) {
                    return dbNum;
                }
                long lngNum = (long)dbNum;
                if (dbNum == (double)lngNum) {
                    return lngNum;
                }
                return dbNum;
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public void write(JsonWriter out, Object value) throws IOException {
    }
}

