/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.filter.crypt.ijiami;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.ijiami.JMEncryptBox;
import com.ijiami.JMEncryptBoxByRandom;
import com.ijiami.LoadMessage;
import com.ijiami.ResultData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.config.ConfigTools3;
import tech.gtt.common.web.filter.crypt.CryptAESIVTools;
import tech.gtt.common.web.filter.crypt.ijiami.IJMConstants;
import tech.gtt.common.web.filter.crypt.ijiami.IJMLogImpl;

public class IJMTools {
    private static final Logger logger = LoggerFactory.getLogger(IJMTools.class);

    public static int getIJMAlgorithm() {
        return ConfigTools3.getInt("crypt.v30.algorithm.type", IJMConstants.ALGORITHM_AES);
    }

    public static String getAESKey() {
        return ConfigTools3.getString("crypt.v30.aes.key", "ZCZtaGFrY2tlOXZjMmpaQw==");
    }

    public static String getAESIVKey() {
        return ConfigTools3.getString("crypt.v30.aes.iv", "oDG&6zcgcpvqkgv6");
    }

    public static String getDefaultDllPath() {
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.contains("window")) {
            return "c:/gtt/dll";
        }
        return "/gtt/dll";
    }

    public static void init() {
        String dllPath = ConfigTools3.getString("crypt.v30.dll.path", IJMTools.getDefaultDllPath());
        boolean ret = JMEncryptBox.initLoadDllPath((String)dllPath, (LoadMessage)new IJMLogImpl());
        logger.info("IJM Init ret:[{}],path[{}]", (Object)ret, (Object)dllPath);
        if (!ret) {
            throw new IllegalArgumentException(String.format("IJM DLL Load faild!path:%s", dllPath));
        }
    }

    public static boolean isCryptIJM(String protocol) {
        return "ACM30".equalsIgnoreCase(Strings.nullToEmpty((String)protocol));
    }

    @Deprecated
    public static String encrypt(String msg) {
        int algorithmType = IJMTools.getIJMAlgorithm();
        try {
            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64((String)msg, (int)IJMTools.getIJMAlgorithm());
            if (!Strings.isNullOrEmpty((String)encryptMsg)) {
                return CryptAESIVTools.encrypt(encryptMsg, IJMTools.getAESKey(), IJMTools.getAESIVKey());
            }
            logger.error("IJM Encrypt failed:{} {}", (Object)algorithmType, (Object)msg);
        }
        catch (Exception e) {
            logger.error("IJM Encrypt failed:{}", (Object)algorithmType, (Object)e);
        }
        return "";
    }

    @Deprecated
    public static String decrypt(String msg) {
        int algorithmType = IJMTools.getIJMAlgorithm();
        try {
            String aesMsg = msg;
            msg = CryptAESIVTools.decrypt(aesMsg, IJMTools.getAESKey(), IJMTools.getAESIVKey());
            if (Strings.isNullOrEmpty((String)msg)) {
                logger.error("IJM Decrypt AES failed:[{}]", (Object)msg);
                return "";
            }
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64((String)msg, (int)algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            }
            logger.error("IJM Decrypt failed:{}{}", (Object)resultData.getStatus(), (Object)msg);
            return "";
        }
        catch (Exception e) {
            logger.error("IJM Decrypt :{}", (Object)algorithmType, (Object)e);
            return "";
        }
    }

    public static String encryptV2(String protocol, String msg) {
        int algorithmType = IJMTools.getIJMAlgorithm();
        try {
            String encryptMsg = JMEncryptBoxByRandom.encryptToBase64((String)msg, (int)IJMTools.getIJMAlgorithm());
            if (!Strings.isNullOrEmpty((String)encryptMsg)) {
                return CryptAESIVTools.encrypt(protocol, encryptMsg);
            }
            logger.error("IJM Encrypt failed:{} {}", (Object)algorithmType, (Object)msg);
        }
        catch (Exception e) {
            logger.error("IJM Encrypt failed:{}", (Object)algorithmType, (Object)e);
        }
        return "";
    }

    public static String decryptV2(String protocol, String msg) {
        int algorithmType = IJMTools.getIJMAlgorithm();
        try {
            String aesMsg = msg;
            msg = CryptAESIVTools.decrypt(protocol, aesMsg);
            if (Strings.isNullOrEmpty((String)msg)) {
                logger.error("IJM Decrypt AES failed:[{}]", (Object)msg);
                return "";
            }
            ResultData resultData = JMEncryptBoxByRandom.decryptFromBase64((String)msg, (int)algorithmType);
            if (resultData.getStatus() == IJMConstants.DECRYPT_STATUS_SUCCESS) {
                return resultData.getText();
            }
            logger.error("IJM Decrypt failed:{}{}", (Object)resultData.getStatus(), (Object)msg);
            return "";
        }
        catch (Exception e) {
            logger.error("IJM Decrypt :{}", (Object)algorithmType, (Object)e);
            return "";
        }
    }

    public static String sign(String msg) {
        return Hashing.sha1().hashString((CharSequence)msg, Charsets.UTF_8).toString();
    }

    static {
        IJMTools.init();
    }
}

