/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.limiter;

import com.google.common.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.limiter.RateLimiterCacheTools;

public abstract class AbstractRateLimiter<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRateLimiter.class);
    protected Cache<K, V> limitCache = null;
    protected String limiterName = "";
    protected int timeUnitSeconds = 0;
    protected int maxPerTimeUnit = 0;

    public AbstractRateLimiter(String limiterName, int timeUnitSeconds, int maxPerTimeUnit) {
        this.limiterName = limiterName;
        this.timeUnitSeconds = timeUnitSeconds;
        this.maxPerTimeUnit = maxPerTimeUnit;
        this.limitCache = RateLimiterCacheTools.createCache(limiterName, timeUnitSeconds);
        logger.info("[{}]Create limiter TimeUnit:[{}] Limit:[{}]", new Object[]{limiterName, timeUnitSeconds, maxPerTimeUnit});
    }

    public abstract long incAndGetCount(K var1, V var2);

    public abstract K getKey(K var1);

    public abstract long getCount(V var1);

    public long addBlock(K key, V value) {
        K limitKey = this.getKey(key);
        Object current = this.limitCache.getIfPresent(limitKey);
        if (current == null) {
            current = value;
        }
        long count = this.incAndGetCount(key, current);
        logger.info("[{}]Add key[{}] count[{}]", new Object[]{this.limiterName, key, count});
        return count;
    }

    public boolean isOutOfLimit(K key, boolean justCheck) {
        K limitKey = this.getKey(key);
        Object current = this.limitCache.getIfPresent(limitKey);
        long currentCount = 0L;
        currentCount = justCheck ? this.getCount(current) : this.incAndGetCount(limitKey, current);
        if (currentCount >= (long)this.maxPerTimeUnit) {
            if (currentCount == (long)this.maxPerTimeUnit) {
                logger.info("[{}]OOL.key[{}] Limit[{}]", new Object[]{this.limiterName, key, this.maxPerTimeUnit});
            }
            if (justCheck) {
                this.incAndGetCount(limitKey, current);
            }
            return true;
        }
        return false;
    }

    public boolean isOutOfLimit(K key) {
        return this.isOutOfLimit(key, false);
    }
}

