/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.type;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LangTools {
    private static final Logger logger = LoggerFactory.getLogger(LangTools.class);
    public static String LANG_PT = "pt";
    public static String LANG_ES = "es";
    public static String LANG_EN = "en";
    public static String LANG_ZH = "zh";
    public static String LANG_IN = "in";
    public static String LANG_ES_TMDB_ALIAS = "spa";

    public static boolean isPortuguese(String language) {
        return LANG_PT.equalsIgnoreCase(language);
    }

    public static boolean isSpanish(String language) {
        return LANG_ES.equalsIgnoreCase(language);
    }

    public static boolean isEnglish(String language) {
        return LANG_EN.equalsIgnoreCase(language);
    }

    public static boolean isChinese(String language) {
        return LANG_ZH.equalsIgnoreCase(language);
    }

    public static boolean isIndonesian(String language) {
        return LANG_IN.equalsIgnoreCase(language);
    }

    public static boolean isSupportLanguage(String language) {
        return LangTools.isEnglish(language) || LangTools.isPortuguese(language) || LangTools.isSpanish(language) || LangTools.isChinese(language) || LangTools.isIndonesian(language);
    }

    public static String spanishAlias(String language) {
        if (LANG_ES_TMDB_ALIAS.equalsIgnoreCase(language)) {
            return LANG_ES;
        }
        return language;
    }

    public static boolean equalLanguage(String lang1, String lang2) {
        if (Strings.isNullOrEmpty((String)lang1) || Strings.isNullOrEmpty((String)lang2)) {
            return false;
        }
        if (lang1.equalsIgnoreCase(lang2)) {
            return true;
        }
        return (LangTools.isEnglish(lang1) || LangTools.isEnglish(lang2)) && LangTools.spanishAlias(lang1).equalsIgnoreCase(LangTools.spanishAlias(lang2));
    }

    public static String getOrDefaultLanguage(String language) {
        if (LangTools.isSupportLanguage(language)) {
            return language;
        }
        return LANG_EN;
    }
}

