/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.uniqueid;

import java.security.SecureRandom;
import java.time.Clock;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import tech.gtt.common.base.uniqueid.Tsid;

public final class TsidFactory {
    private int counter;
    private long lastTime;
    private final int node;
    private final int nodeBits;
    private final int counterBits;
    private final int nodeMask;
    private final int counterMask;
    private final long customEpoch;
    private final LongSupplier timeFunction;
    private final IRandom random;
    private final int randomBytes;
    private final ReentrantLock lock = new ReentrantLock();
    static final int NODE_BITS_256 = 8;
    static final int NODE_BITS_1024 = 10;
    static final int NODE_BITS_4096 = 12;
    static final int NODE_BITS_65536 = 16;

    public TsidFactory() {
        this(TsidFactory.builder());
    }

    public TsidFactory(int node) {
        this(TsidFactory.builder().withNode(node));
    }

    private TsidFactory(Builder builder) {
        this.customEpoch = builder.getCustomEpoch();
        this.nodeBits = builder.getNodeBits();
        this.random = builder.getRandom();
        this.timeFunction = builder.getTimeFunction();
        this.counterBits = 22 - this.nodeBits;
        this.counterMask = 0x3FFFFF >>> this.nodeBits;
        this.nodeMask = 0x3FFFFF >>> this.counterBits;
        this.randomBytes = (this.counterBits - 1) / 8 + 1;
        this.node = builder.getNode() & this.nodeMask;
        this.lastTime = 0L;
        this.counter = this.getRandomCounter();
    }

    public static TsidFactory newInstance256() {
        return TsidFactory.builder().withNodeBits(8).build();
    }

    public static TsidFactory newInstance256(int node) {
        return TsidFactory.builder().withNodeBits(8).withNode(node).build();
    }

    public static TsidFactory newInstance1024() {
        return TsidFactory.builder().withNodeBits(10).build();
    }

    public static TsidFactory newInstance1024(int node) {
        return TsidFactory.builder().withNodeBits(10).withNode(node).build();
    }

    public static TsidFactory newInstance4096() {
        return TsidFactory.builder().withNodeBits(12).build();
    }

    public static TsidFactory newInstance4096(int node) {
        return TsidFactory.builder().withNodeBits(12).withNode(node).build();
    }

    public static TsidFactory newInstance65536() {
        return TsidFactory.builder().withNodeBits(16).build();
    }

    public static TsidFactory newInstance65536(int node) {
        return TsidFactory.builder().withNodeBits(16).withNode(node).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tsid create() {
        this.lock.lock();
        try {
            long _time = this.getTime() << 22;
            long _node = (long)this.node << this.counterBits;
            long _counter = (long)this.counter & (long)this.counterMask;
            Tsid tsid = new Tsid(_time | _node | _counter);
            return tsid;
        }
        finally {
            this.lock.unlock();
        }
    }

    private long getTime() {
        long time = this.timeFunction.getAsLong();
        if (time <= this.lastTime) {
            ++this.counter;
            int carry = this.counter >>> this.counterBits;
            this.counter &= this.counterMask;
            time = this.lastTime + (long)carry;
        } else {
            this.counter = this.getRandomCounter();
        }
        this.lastTime = time;
        return time - this.customEpoch;
    }

    private int getRandomCounter() {
        if (this.random instanceof ByteRandom) {
            byte[] bytes = this.random.nextBytes(this.randomBytes);
            switch (bytes.length) {
                case 1: {
                    return bytes[0] & 0xFF & this.counterMask;
                }
                case 2: {
                    return ((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF) & this.counterMask;
                }
            }
            return ((bytes[0] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[2] & 0xFF) & this.counterMask;
        }
        return this.random.nextInt() & this.counterMask;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer node;
        private Integer nodeBits;
        private Long customEpoch;
        private IRandom random;
        private LongSupplier timeFunction;

        public Builder withNode(Integer node) {
            this.node = node;
            return this;
        }

        public Builder withNodeBits(Integer nodeBits) {
            this.nodeBits = nodeBits;
            return this;
        }

        public Builder withCustomEpoch(Instant customEpoch) {
            this.customEpoch = customEpoch.toEpochMilli();
            return this;
        }

        public Builder withRandom(Random random) {
            if (random != null) {
                this.random = random instanceof SecureRandom ? new ByteRandom(random) : new IntRandom(random);
            }
            return this;
        }

        public Builder withRandomFunction(IntSupplier randomFunction) {
            this.random = new IntRandom(randomFunction);
            return this;
        }

        public Builder withRandomFunction(IntFunction<byte[]> randomFunction) {
            this.random = new ByteRandom(randomFunction);
            return this;
        }

        public Builder withClock(Clock clock) {
            this.timeFunction = () -> clock.millis();
            return this;
        }

        public Builder withTimeFunction(LongSupplier timeFunction) {
            this.timeFunction = timeFunction;
            return this;
        }

        protected Integer getNode() {
            int max = (1 << this.nodeBits) - 1;
            if (this.node == null) {
                this.node = Settings.getNode() != null ? Settings.getNode() : Integer.valueOf(this.random.nextInt() & max);
            }
            if (this.node < 0 || this.node > max) {
                throw new IllegalArgumentException(String.format("Node ID out of range [0, %s]: %s", max, this.node));
            }
            return this.node;
        }

        protected Integer getNodeBits() {
            if (this.nodeBits == null) {
                this.nodeBits = Settings.getNodeCount() != null ? Integer.valueOf((int)Math.ceil(Math.log(Settings.getNodeCount().intValue()) / Math.log(2.0))) : Integer.valueOf(10);
            }
            if (this.nodeBits < 0 || this.nodeBits > 20) {
                throw new IllegalArgumentException(String.format("Node bits out of range [0, 20]: %s", this.nodeBits));
            }
            return this.nodeBits;
        }

        protected Long getCustomEpoch() {
            if (this.customEpoch == null) {
                this.customEpoch = Tsid.TSID_EPOCH;
            }
            return this.customEpoch;
        }

        protected IRandom getRandom() {
            if (this.random == null) {
                this.withRandom(new SecureRandom());
            }
            return this.random;
        }

        protected LongSupplier getTimeFunction() {
            if (this.timeFunction == null) {
                this.withTimeFunction(System::currentTimeMillis);
            }
            return this.timeFunction;
        }

        public TsidFactory build() {
            return new TsidFactory(this);
        }
    }

    static interface IRandom {
        public int nextInt();

        public byte[] nextBytes(int var1);
    }

    static class ByteRandom
    implements IRandom {
        private final IntFunction<byte[]> randomFunction;

        public ByteRandom() {
            this(ByteRandom.newRandomFunction(null));
        }

        public ByteRandom(Random random) {
            this(ByteRandom.newRandomFunction(random));
        }

        public ByteRandom(IntFunction<byte[]> randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : ByteRandom.newRandomFunction(null);
        }

        @Override
        public int nextInt() {
            int number = 0;
            byte[] bytes = this.randomFunction.apply(4);
            for (int i = 0; i < 4; ++i) {
                number = number << 8 | bytes[i] & 0xFF;
            }
            return number;
        }

        @Override
        public byte[] nextBytes(int length) {
            return this.randomFunction.apply(length);
        }

        protected static IntFunction<byte[]> newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return length -> {
                byte[] bytes = new byte[length];
                entropy.nextBytes(bytes);
                return bytes;
            };
        }
    }

    static class Settings {
        static final String NODE = "tsidcreator.node";
        static final String NODE_COUNT = "tsidcreator.node.count";

        private Settings() {
        }

        public static Integer getNode() {
            return Settings.getPropertyAsInteger(NODE);
        }

        public static Integer getNodeCount() {
            return Settings.getPropertyAsInteger(NODE_COUNT);
        }

        static Integer getPropertyAsInteger(String property) {
            try {
                return Integer.decode(Settings.getProperty(property));
            }
            catch (NullPointerException | NumberFormatException e) {
                return null;
            }
        }

        static String getProperty(String name) {
            String property = System.getProperty(name);
            if (property != null && !property.isEmpty()) {
                return property;
            }
            String variable = System.getenv(name.toUpperCase().replace(".", "_"));
            if (variable != null && !variable.isEmpty()) {
                return variable;
            }
            return null;
        }
    }

    static class IntRandom
    implements IRandom {
        private final IntSupplier randomFunction;

        public IntRandom() {
            this(IntRandom.newRandomFunction(null));
        }

        public IntRandom(Random random) {
            this(IntRandom.newRandomFunction(random));
        }

        public IntRandom(IntSupplier randomFunction) {
            this.randomFunction = randomFunction != null ? randomFunction : IntRandom.newRandomFunction(null);
        }

        @Override
        public int nextInt() {
            return this.randomFunction.getAsInt();
        }

        @Override
        public byte[] nextBytes(int length) {
            int shift = 0;
            long random = 0L;
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                if (shift < 8) {
                    shift = 32;
                    random = this.randomFunction.getAsInt();
                }
                bytes[i] = (byte)(random >>> (shift -= 8));
            }
            return bytes;
        }

        protected static IntSupplier newRandomFunction(Random random) {
            Random entropy = random != null ? random : new SecureRandom();
            return entropy::nextInt;
        }
    }
}

