/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.config.config;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.config.AbstractConfigTools;
import tech.gtt.common.config.config.ConfigValueTools;
import tech.gtt.common.config.config.listener.IConfigChangeListener;
import tech.gtt.common.config.configcenter.ConfigCenterService;
import tech.gtt.common.config.configcenter.common.ConfigOverrideTools;
import tech.gtt.common.config.file.monitor.FileContentListener;
import tech.gtt.common.config.file.monitor.PathFileMonitor;
import tech.gtt.common.config.model.ConfigToolConfigDTO;
import tech.gtt.common.config.model.LocalConfigDTO;

public class ConfigRouteTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRouteTools.class);

    public void loadConfig(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        long start = System.currentTimeMillis();
        this.initParameter(configObj);
        switch (configObj.getRunMode()) {
            case 1: {
                this.localStart(configObj, listener);
                break;
            }
            case 2: {
                this.configCenterStart(configObj, listener);
                break;
            }
            case 3: {
                this.localStart(configObj, listener);
                this.configCenterStart(configObj, listener);
                break;
            }
        }
        logger.info("loading finished,runMode:[{}] time consume:[{}]s", (Object)configObj.getRunMode(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private void initParameter(ConfigToolConfigDTO configObj) {
        ConfigOverrideTools.initLevels(configObj.getProject(), configObj.getModule(), configObj.getEnv(), configObj.getRegion());
        ConfigValueTools.extSet = new HashSet<String>(configObj.getPropertiesExtension());
    }

    private void localStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        LocalConfigDTO localInitInfo = configObj.getLocalConfig();
        new PathFileMonitor(localInitInfo.getRefreshInterval()).monitorPath(AbstractConfigTools.replaceDirectoryPath(localInitInfo.getPath()), null, null, new FileContentListener(false, listener), localInitInfo.getRecursive()).start();
    }

    private void configCenterStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        new ConfigCenterService(configObj.getConfigCenterConfig()).load(listener);
    }
}

