/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.config.data;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.data.IDataChangeListener;
import tech.gtt.common.config.data.IPropertyData;
import tech.gtt.common.config.model.ConfigValueDTO;

public class DataChangeListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DataChangeListener.class);
    private long lmt = 0L;
    private long queryInterval;
    private IDataChangeListener iChangeLister;
    private Map<String, ConfigValueDTO> properties;

    public DataChangeListener(long queryInterval, Map<String, ConfigValueDTO> properties, IDataChangeListener iChangeLister) {
        this.queryInterval = queryInterval;
        this.iChangeLister = iChangeLister;
        this.properties = properties;
    }

    public long getQueryInterval() {
        return this.queryInterval;
    }

    @Override
    public void run() {
        long cmt = System.currentTimeMillis();
        if (cmt - this.lmt >= this.queryInterval) {
            List<Object> dataObjects = this.iChangeLister.queryData(this.lmt);
            if (Objects.nonNull(dataObjects)) {
                dataObjects.forEach(e -> {
                    if (e instanceof IPropertyData) {
                        this.iChangeLister.processData((IPropertyData)e, this.properties);
                    }
                });
            }
            this.lmt = cmt;
        }
    }
}

