/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.config.config.loader;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.config.loader.json.JsonSerialize;
import tech.gtt.common.config.model.ConfigToolConfigDTO;

public class ConfigToolsConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigToolsConfigLoader.class);

    public static ConfigToolConfigDTO getConfigObj(String cfgFilePath) {
        File cfgFile = ConfigToolsConfigLoader.getConfigObjFile(cfgFilePath);
        if (Objects.isNull(cfgFile)) {
            return new ConfigToolConfigDTO(1, cfgFilePath);
        }
        return ConfigToolsConfigLoader.getConfigObj(cfgFile);
    }

    private static File getConfigObjFile(String cfgFile) {
        if (Strings.isNullOrEmpty((String)cfgFile)) {
            return null;
        }
        File root = FileUtils.getFile((String[])new String[]{cfgFile});
        if (!root.exists()) {
            throw new RuntimeException("File is not Exist\uff1a" + String.valueOf(root));
        }
        if (root.isFile()) {
            return root;
        }
        File configJsonFile = FileUtils.getFile((File)root, (String[])new String[]{"config.json"});
        if (configJsonFile.isFile()) {
            return configJsonFile;
        }
        return null;
    }

    private static ConfigToolConfigDTO getConfigObj(File configToolConfigFile) {
        ConfigToolConfigDTO configObj = (ConfigToolConfigDTO)JsonSerialize.loadJson(configToolConfigFile, (TypeReference)new TypeReference<ConfigToolConfigDTO>(){});
        if (configObj == null) {
            logger.error("Config json is wrong");
            throw new RuntimeException("Please check if the format of the config.json file is correct");
        }
        if (!configObj.valid()) {
            throw new RuntimeException("Please check if the format of the config.json file is correct");
        }
        return configObj;
    }
}

