/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.uniqueid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.uniqueid.TsidCreator;
import tech.gtt.common.base.uniqueid.TsidFactory;
import tech.gtt.common.base.uniqueid.Xid;

public class UniqueIdGenerate {
    private static final Logger logger = LoggerFactory.getLogger(UniqueIdGenerate.class);
    private static final UniqueIdGenerate instance = new UniqueIdGenerate();
    private static final int TYPE_DEFAULT = 0;
    private static final int TYPE_LIMIT_15 = 1;

    private UniqueIdGenerate() {
    }

    public static UniqueIdGenerate getInstance() {
        return instance;
    }

    public String getUniqueIdString() {
        return new Xid().toHexString();
    }

    public byte[] getUniqueIdByteArray() {
        return new Xid().toByteArray();
    }

    public Long getUniqueIdLong(String podIP) {
        int node = this.getNode(podIP);
        if (node == -1) {
            return TsidCreator.getTsid().toLong();
        }
        return TsidFactory.newInstance65536(node, 0).create().toLong();
    }

    public Long getUniqueIdLongLimit(String podIP) {
        int node = this.getNode(podIP);
        if (node == -1) {
            return TsidFactory.newInstanceDefault(1).create().toLong();
        }
        return TsidFactory.newInstance65536(node, 1).create().toLong();
    }

    private int getNode(String podIP) {
        String lastOne;
        String lastTwo;
        if (podIP == null || podIP.isEmpty()) {
            logger.error("podIP is null or empty, use default method to generate unique id");
            return -1;
        }
        try {
            String[] split = podIP.split("\\.");
            lastTwo = split[2];
            lastOne = split[3];
            if (Integer.parseInt(lastOne) > 255 || Integer.parseInt(lastOne) < 0 || Integer.parseInt(lastTwo) > 255 || Integer.parseInt(lastTwo) < 0) {
                logger.error("podIP is illegal, lastTwo is {},lastOne is {}.Use default method to generate unique id", (Object)lastTwo, (Object)lastOne);
                return -1;
            }
        }
        catch (Exception e) {
            logger.error("podIP is illegal, use default method to generate unique id");
            return -1;
        }
        String lastTwoBinary = String.format("%8s", Integer.toBinaryString(Integer.parseInt(lastTwo))).replace(' ', '0');
        String lastOneBinary = String.format("%8s", Integer.toBinaryString(Integer.parseInt(lastOne))).replace(' ', '0');
        String nodeBinary = lastTwoBinary + lastOneBinary;
        int nodeIdentifier = Integer.parseInt(nodeBinary, 2);
        return nodeIdentifier;
    }
}

