/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Method;
import java.util.Arrays;
import tech.gtt.common.base.validator.EnumValue;

public class EnumValueValidator
implements ConstraintValidator<EnumValue, String> {
    private Class<? extends Enum<?>> enumClass;
    private String checkMethodName;

    public void initialize(EnumValue constraintAnnotation) {
        this.enumClass = constraintAnnotation.enumClass();
        this.checkMethodName = constraintAnnotation.methodName();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        try {
            Method method = this.enumClass.getMethod(this.checkMethodName, String.class);
            Object result = method.invoke(null, value);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
        }
        catch (NoSuchMethodException e) {
            return this.checkEnumParamByNames(value);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private boolean checkEnumParamByNames(String value) {
        return Arrays.stream(this.enumClass.getEnumConstants()).anyMatch(e -> e.name().equals(value));
    }
}

