/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.ipdb.api.iphub;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.config.ConfigTools3;
import tech.gtt.common.ipdb.api.IIPDBApi;
import tech.gtt.common.ipdb.httptool.HCTools;
import tech.gtt.common.ipdb.httptool.HttpResponse;
import tech.gtt.common.ipdb.model.IPInfo;

public class IPHubApi
implements IIPDBApi {
    private static final Logger logger = LoggerFactory.getLogger(IPHubApi.class);
    private static Gson gson = new Gson();

    @Override
    public IPInfo query(String ip) {
        try {
            String apiUrlTpl = ConfigTools3.getString("ipdb.api.iphub.url", "http://v2.api.iphub.info/ip/%s");
            String apiAuthKey = ConfigTools3.getNonEmptyString("ipdb.api.iphub.key");
            ImmutableMap headers = ImmutableMap.of((Object)"X-key", (Object)apiAuthKey);
            HttpResponse response = HCTools.get(String.format(apiUrlTpl, ip), (Map<String, String>)headers);
            if (response.getStatus() == 200 && !Strings.isNullOrEmpty((String)response.getBody())) {
                return (IPInfo)gson.fromJson(response.getBody(), IPInfo.class);
            }
        }
        catch (Exception e) {
            logger.error("IP[{}]", (Object)ip, (Object)e);
            return null;
        }
        return null;
    }
}

