/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.ipdb.api.geoip;

import com.github.davidmoten.geo.GeoHash;
import com.google.common.base.Strings;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.ipdb.api.geoip.EGeoIPDBType;
import tech.gtt.common.ipdb.api.geoip.GeoIPReaderFactory;
import tech.gtt.common.ipdb.model.IPASNInfo;
import tech.gtt.common.ipdb.model.IPInfo;

public class GeoIPService {
    private static final Logger logger = LoggerFactory.getLogger(GeoIPService.class);

    public static IPInfo getCityInfo(String ip) {
        try {
            Postal postal;
            Location location;
            Country country;
            DatabaseReader reader = GeoIPReaderFactory.getReader(EGeoIPDBType.GEOLITE2_CITY);
            if (reader == null) {
                return null;
            }
            InetAddress ipAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(ipAddress);
            if (response == null) {
                return null;
            }
            IPInfo ipInfo = new IPInfo();
            ipInfo.setIp(ip);
            City city = response.getCity();
            if (city != null) {
                ipInfo.setCity(city.getName());
            }
            if ((country = response.getCountry()) != null) {
                ipInfo.setCountry(Strings.nullToEmpty((String)country.getIsoCode()).toLowerCase());
            }
            if ((location = response.getLocation()) != null) {
                ipInfo.setLatitude(location.getLatitude());
                ipInfo.setLongitude(location.getLongitude());
                ipInfo.setLocation(String.format("%s,%s", location.getLatitude(), location.getLongitude()));
                String geoHash = GeoHash.encodeHash((double)location.getLatitude(), (double)location.getLongitude());
                ipInfo.setGeoHash(geoHash);
            }
            if ((postal = response.getPostal()) != null) {
                ipInfo.setPostCode(postal.getCode());
            }
            return ipInfo;
        }
        catch (Exception e) {
            GeoIPService.printException(ip, e);
            return null;
        }
    }

    private static void printException(String ip, Exception e) {
        if (e instanceof AddressNotFoundException) {
            logger.debug("IP[{}] Not Found", (Object)ip, (Object)e.getMessage());
        } else {
            logger.error("IP[{}] message:[{}]", (Object)ip, (Object)e);
        }
    }

    public static IPASNInfo getASNInfo(String ip) {
        try {
            DatabaseReader reader = GeoIPReaderFactory.getReader(EGeoIPDBType.GEOLITE2_ASN);
            if (reader == null) {
                return null;
            }
            InetAddress ipAddress = InetAddress.getByName(ip);
            AsnResponse response = reader.asn(ipAddress);
            if (response == null) {
                return null;
            }
            IPASNInfo asnInfo = new IPASNInfo();
            asnInfo.setASN(Math.toIntExact(response.getAutonomousSystemNumber()));
            asnInfo.setASO(response.getAutonomousSystemOrganization());
            return asnInfo;
        }
        catch (Exception e) {
            GeoIPService.printException(ip, e);
            return null;
        }
    }

    public static IPInfo getIPInfo(String ip) {
        if (Strings.isNullOrEmpty((String)ip)) {
            return null;
        }
        if (GeoIPReaderFactory.isEmpty()) {
            return null;
        }
        try {
            IPASNInfo asnInfo;
            IPInfo info = GeoIPService.getCityInfo(ip);
            if (info != null && (asnInfo = GeoIPService.getASNInfo(ip)) != null) {
                info.setASN(asnInfo.getASN());
                info.setASO(asnInfo.getASO());
            }
            return info;
        }
        catch (Exception e) {
            logger.error("IP[{}] message:[{}]", (Object)ip, (Object)e.getMessage());
            return null;
        }
    }

    public static String getCountry(String ip) {
        IPInfo ipInfo = GeoIPService.getCityInfo(ip);
        if (ipInfo == null) {
            return "";
        }
        return Strings.nullToEmpty((String)ipInfo.getCountry());
    }
}

