/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.webapi.processor;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.gtt.common.base.exception.ApiException;
import tech.gtt.common.base.stat.StatTools;
import tech.gtt.common.web.http.HttpTools;
import tech.gtt.common.web.webapi.annotation.WebApiCall;

@Service
@Aspect
public class WebApiCallInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCallInterceptor.class);

    @Pointcut(value="@annotation(common.web.tools.webapi.annotation.WebApiCall)")
    public void webApiCall() {
    }

    @Around(value="common.web.tools.webapi.processor.WebApiCallInterceptor.webApiCall()&&@annotation(wac)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiCall wac) throws ServletException, IOException, ApiException {
        String apiName = this.getApiName((JoinPoint)pjp);
        String apiPath = this.getApiPath((JoinPoint)pjp);
        StatTools.addReq(apiName);
        HttpServletRequest request = this.getRequest((JoinPoint)pjp);
        HttpServletResponse response = this.getResponse((JoinPoint)pjp);
        String host = HttpTools.getRemoteHost(request);
        try {
            Long appVer;
            if (wac.minVersion() > 0 && ((appVer = HttpTools.getLongParameter(request, "appVer")) == null || appVer < (long)wac.minVersion())) {
                throw new ApiException(-999999, "Unsupported version");
            }
            StatTools.startTimer(apiName);
            Object retVal = pjp.proceed();
            StatTools.stopTimer(apiName);
            if (wac.cacheControl() > 0) {
                this.getResponse((JoinPoint)pjp).setHeader("Cache-Control", "max-age=" + wac.cacheControl());
            }
            return retVal;
        }
        catch (Throwable throwable) {
            logger.error("API:[{}] Exception:[{}]", (Object)apiPath, (Object)throwable.toString());
            throw new ApiException(-999, "Internal error");
        }
    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest)jp.getArgs()[0];
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse)jp.getArgs()[1];
    }

    public String getApiName(JoinPoint jp) {
        String apiName = this.getRequest(jp).getRequestURI();
        apiName = apiName.substring(1).replace("/", "-");
        return apiName;
    }

    public String getApiPath(JoinPoint jp) {
        return this.getRequest(jp).getRequestURI();
    }
}

