/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.webapi.processor;

import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.gtt.common.base.statistics.TimeStatisticsTools2;
import tech.gtt.common.config.config.ConfigTools3;
import tech.gtt.common.web.statistics.scheduler.WebApiStatisticsReportTools;
import tech.gtt.common.web.webapi.annotation.WebApiStatistics;

@Aspect
@Service
public class WebApiStatisticsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsProcessor.class);
    private static final String API_STATISTICS_SWITCH_KEY = "api.statistics";

    @Pointcut(value="@annotation(common.web.tools.webapi.annotation.WebApiStatistics)")
    public void webApiStatisticsCall() {
    }

    @Around(value="common.web.tools.webapi.processor.WebApiStatisticsProcessor.webApiStatisticsCall()&&@annotation(was)")
    public Object apiInvoke(ProceedingJoinPoint pjp, WebApiStatistics was) throws Throwable {
        String apiName = this.getApiName(pjp, was);
        boolean isStatistics = this.getStatisticsSwitch(apiName);
        if (isStatistics) {
            TimeStatisticsTools2.startTimer(apiName);
        }
        Object retVal = pjp.proceed();
        if (isStatistics) {
            long time = TimeStatisticsTools2.stopTimer(apiName);
            WebApiStatisticsReportTools.reportSlowRequest(apiName, time);
        }
        return retVal;
    }

    private String getApiName(ProceedingJoinPoint pjp, WebApiStatistics was) {
        String apiName = was.apiName();
        if (Strings.isNullOrEmpty((String)apiName)) {
            apiName = this.getApiNameFromRequest(pjp);
        }
        if (!Strings.isNullOrEmpty((String)apiName)) {
            return apiName.replace("/", "-");
        }
        return pjp.toShortString();
    }

    private boolean getStatisticsSwitch(String apiName) {
        if (Strings.isNullOrEmpty((String)apiName)) {
            return false;
        }
        String key = String.format("%s.%s", API_STATISTICS_SWITCH_KEY, apiName);
        return ConfigTools3.getBoolean(key, ConfigTools3.getBoolean(API_STATISTICS_SWITCH_KEY, true));
    }

    private String getApiNameFromRequest(ProceedingJoinPoint pjp) {
        String requestURL;
        Object[] args = pjp.getArgs();
        if (args.length == 0) {
            return "";
        }
        Object argFirst = args[0];
        if (argFirst instanceof HttpServletRequest && !Strings.isNullOrEmpty((String)(requestURL = ((HttpServletRequest)argFirst).getRequestURI()))) {
            if (requestURL.startsWith("/")) {
                requestURL = requestURL.substring(1);
            }
            return requestURL.replace("/", "-");
        }
        return "";
    }
}

