/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.ipdb.api.geoip;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.ipdb.api.geoip.EGeoIPDBType;
import tech.gtt.common.ipdb.api.geoip.GeoIPConfig;
import tech.gtt.common.ipdb.api.geoip.GeoIPReaderFactory;
import tech.gtt.common.ipdb.filemanager.FiledTools;

public class GeoIPDBManager {
    private static final Logger logger = LoggerFactory.getLogger(GeoIPDBManager.class);
    private static boolean isRunning = false;
    private static boolean isStartupRunning = false;
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(4);
    private static Map<EGeoIPDBType, GeoDownloader> downloaderMap = Maps.newHashMap();

    public static void downloadIfDbNotExists() {
        for (EGeoIPDBType type : EGeoIPDBType.values()) {
            GeoDownloader downloader;
            if (GeoIPConfig.isDbExist(type) || !Objects.nonNull(downloader = downloaderMap.get((Object)type))) continue;
            downloader.run();
        }
    }

    public static void startAutoUpdate() {
        if (isRunning) {
            return;
        }
        for (EGeoIPDBType type : EGeoIPDBType.values()) {
            GeoDownloader downloader = downloaderMap.get((Object)type);
            if (!Objects.nonNull(downloader)) continue;
            executor.scheduleWithFixedDelay(downloader, 1L, GeoIPConfig.updateDuration(), TimeUnit.MINUTES);
            logger.info("Start db [{}] auto update duration[{}m]", (Object)type, (Object)GeoIPConfig.updateDuration());
        }
        isRunning = true;
    }

    public static void stop() {
        executor.shutdown();
    }

    public static void startup() {
        if (isStartupRunning) {
            return;
        }
        FiledTools.mkdirsIfNotExist(GeoIPConfig.dbPath());
        GeoIPDBManager.downloadIfDbNotExists();
        for (EGeoIPDBType type : EGeoIPDBType.values()) {
            GeoIPReaderFactory.load(type);
        }
        GeoIPDBManager.startAutoUpdate();
        isStartupRunning = true;
    }

    static {
        for (EGeoIPDBType type : EGeoIPDBType.values()) {
            if (downloaderMap.containsKey((Object)type)) continue;
            downloaderMap.putIfAbsent(type, new GeoDownloader(type));
        }
    }

    public static class GeoDownloader
    implements Runnable {
        private EGeoIPDBType type;

        public GeoDownloader(EGeoIPDBType type) {
            this.type = type;
        }

        @Override
        public void run() {
            if (GeoIPConfig.dbAutoUpdate() && FiledTools.isNeedUpdate(this.type)) {
                String url = GeoIPConfig.dbDownloadUrl(this.type);
                String downloadFilename = GeoIPConfig.getDBDownloadFilename(this.type);
                FiledTools.download(url, downloadFilename);
                FiledTools.uncompressTarGzip(downloadFilename, GeoIPConfig.dbPath(), this.type.getSuffix());
            }
            GeoIPReaderFactory.load(this.type);
        }
    }
}

