/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.filter.common;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import tech.gtt.common.base.type.CollectionUtils;
import tech.gtt.common.web.filter.common.ServletInputStreamWrapper;

public class WebRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(WebRequestWrapper.class);
    private Map<String, String[]> parameterMap = new HashMap<String, String[]>();
    private String bodyStr = "";
    private String originalBodyStr = "";
    private Gson gson = new Gson();

    public WebRequestWrapper(HttpServletRequest request) {
        super(request);
        if (HttpMethod.POST.name().equalsIgnoreCase(request.getMethod())) {
            this.bodyStr = this.getRequestBody(request);
        }
        this.parameterMap.putAll(request.getParameterMap());
    }

    public String getParameter(String name) {
        String[] values = this.parameterMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameterMap.keySet());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStreamWrapper(Strings.nullToEmpty((String)this.originalBodyStr).getBytes(Charsets.UTF_8));
    }

    public void addAllParameters(Map<String, Object> otherParams) {
        if (!CollectionUtils.isNullOrEmpty(otherParams)) {
            for (Map.Entry<String, Object> entry : otherParams.entrySet()) {
                this.addParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setOriginalBodyStr(String originalBodyStr) {
        this.originalBodyStr = originalBodyStr;
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.parameterMap.put(name, (String[])value);
            } else if (value instanceof String) {
                this.parameterMap.put(name, new String[]{(String)value});
            } else {
                this.parameterMap.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    private String getRequestBody(HttpServletRequest request) {
        Map postMap;
        String requestBody = WebRequestWrapper.getRequestBodyString(request);
        if (!Strings.isNullOrEmpty((String)requestBody) && !CollectionUtils.isNullOrEmpty(postMap = (Map)this.gson.fromJson(requestBody, Map.class))) {
            postMap.forEach((k, v) -> this.addParameter((String)k, v));
        }
        return Strings.nullToEmpty((String)requestBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequestBodyString(HttpServletRequest request) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder("");
        try {
            String str;
            br = request.getReader();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

