/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.webapi.processor;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.gtt.common.base.exception.ApiException;
import tech.gtt.common.base.type.CollectionUtils;
import tech.gtt.common.base.type.StringTools;
import tech.gtt.common.config.config.ConfigTools3;
import tech.gtt.common.web.http.HttpTools;
import tech.gtt.common.web.webapi.annotation.WebApiAuthorizedIP;

@Aspect
@Service
public class WebApiAuthorizedIPInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiAuthorizedIPInterceptor.class);

    @Pointcut(value="@annotation(common.web.tools.webapi.annotation.WebApiAuthorizedIP)")
    public void webApiCallIpCheck() {
    }

    @Before(value="common.web.tools.webapi.processor.WebApiAuthorizedIPInterceptor.webApiCallIpCheck()&&@annotation(wacic)")
    public void authIpCheck(JoinPoint jp, WebApiAuthorizedIP wacic) throws ApiException {
        List<String> authIpList;
        HashSet authIps = Sets.newHashSet();
        String ips = wacic.authIps();
        String ipCfgName = wacic.authIpCfgName();
        if (!Strings.isNullOrEmpty((String)ips)) {
            authIps.addAll(StringTools.parseAsList(ips, ","));
        }
        if (!Strings.isNullOrEmpty((String)ipCfgName) && !CollectionUtils.isNullOrEmpty(authIpList = ConfigTools3.getAsList(ipCfgName))) {
            authIps.addAll(authIpList);
        }
        if (CollectionUtils.isNullOrEmpty(authIps)) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)jp.getArgs()[0];
        String clientIp = HttpTools.getRemoteHost(request);
        if (!authIps.contains(clientIp)) {
            String msg = String.format("IP[%s] is not authorized", clientIp);
            logger.warn(msg);
            throw new ApiException(-9991, msg);
        }
    }
}

