/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.limiter;

import com.google.common.cache.Cache;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.limiter.RateBlockLimiter;
import tech.gtt.common.base.limiter.RateCountLimiter;
import tech.gtt.common.base.limiter.RateLimiterCacheTools;
import tech.gtt.common.base.limiter.RateLimiterContinuousStat;
import tech.gtt.common.base.limiter.RateLimiterTools;

public class RateCountAndBlockLimiter
extends RateCountLimiter {
    private static final Logger logger = LoggerFactory.getLogger(RateCountAndBlockLimiter.class);
    private Cache<String, RateLimiterContinuousStat> lastOOLCache = null;
    private RateBlockLimiter blockLimiter = null;
    private boolean isSupportBlock = false;
    private int blockLimit = 0;

    public RateCountAndBlockLimiter(String limiterName, int timeUnitSeconds, int countLimit, int blockTimeSeconds, int blockLimit) {
        super(limiterName + "-COUNT", timeUnitSeconds, countLimit);
        this.blockLimit = blockLimit;
        if (blockTimeSeconds > 0 && blockLimit > 0) {
            this.lastOOLCache = RateLimiterCacheTools.createCache(limiterName + "-STAT", (blockLimit + 1) * timeUnitSeconds);
            this.blockLimiter = new RateBlockLimiter(limiterName + "-BLOCK", blockTimeSeconds);
            this.isSupportBlock = true;
        }
    }

    @Override
    public boolean isOutOfLimit(String key) {
        boolean isOutOfLimit;
        if (this.blockLimiter != null && (isOutOfLimit = this.blockLimiter.isOutOfLimit(key))) {
            return true;
        }
        isOutOfLimit = super.isOutOfLimit(key);
        if (isOutOfLimit) {
            int count;
            if (this.isSupportBlock && (count = this.getContinuousCount(key)) >= this.blockLimit) {
                this.blockLimiter.addBlock(key, new AtomicLong(0L));
            }
            return true;
        }
        return false;
    }

    public int getContinuousCount(String key) {
        if (!this.isSupportBlock) {
            return 0;
        }
        long currentPeriod = RateLimiterTools.getPeriodStartTime(this.timeUnitSeconds);
        RateLimiterContinuousStat stat = (RateLimiterContinuousStat)this.lastOOLCache.getIfPresent((Object)key);
        if (stat != null && stat.getLastCycle() == currentPeriod) {
            return stat.getCount();
        }
        if (stat == null) {
            stat = new RateLimiterContinuousStat(currentPeriod, 1);
        }
        int count = 1;
        if (currentPeriod - stat.getLastCycle() == (long)this.timeUnitSeconds) {
            count = stat.getCount() + 1;
        }
        stat.setLastCycle(currentPeriod);
        stat.setCount(count);
        this.lastOOLCache.put((Object)key, (Object)stat);
        return stat.getCount();
    }
}

