/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.multithread;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.multithread.ChangedRunner2;
import tech.gtt.common.base.multithread.IChangedProcessorFactory;
import tech.gtt.common.base.multithread.IChangedScanner;
import tech.gtt.common.base.multithread.ThreadRunTool;

public class ChangedScanRunner2 {
    private static final Logger logger = LoggerFactory.getLogger(ChangedScanRunner2.class);
    private IChangedScanner scanner;
    private IChangedProcessorFactory processorFactory;
    private String scannerName = "";

    public ChangedScanRunner2(String scannerName, IChangedScanner scanner, IChangedProcessorFactory processorFactory) {
        this.scanner = scanner;
        this.processorFactory = processorFactory;
        this.scannerName = scannerName;
    }

    public void run(int maxResult, int maxThreads, int waitMS) {
        this.run(maxResult, maxThreads, waitMS, true);
    }

    public void run(int maxResult, int maxThreads, int waitMS, boolean printIfNoData) {
        BlockingQueue queue = this.scanner.getChanged(maxResult);
        if (Objects.nonNull(queue) && queue.size() > 0) {
            logger.info("[{}] is running with records[{}-{}].", new Object[]{this.scannerName, maxResult, queue.size()});
            ThreadRunTool.runThreads(maxThreads, waitMS, new ChangedRunner2(queue, this.processorFactory));
        } else if (printIfNoData) {
            logger.info("[{}] no records need process.", (Object)this.scannerName);
        }
    }
}

