/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.sys;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.type.StringTools;

public class SystemTools {
    private static final Logger logger = LoggerFactory.getLogger(SystemTools.class);
    private static String ipv4 = null;
    private static String ipv6 = null;
    private static String hostname = "";
    private static String tmpDir = "";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    private SystemTools() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String getIpAddress() {
        return SystemTools.getIpAddress(Boolean.TRUE);
    }

    public static String getIpAddress(boolean getIpv4) {
        if (getIpv4 && ipv4 != null) {
            return ipv4;
        }
        if (!getIpv4 && ipv6 != null) {
            return ipv6;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            boolean found = Boolean.FALSE;
            while (!found && interfaces.hasMoreElements()) {
                NetworkInterface currentInterface = interfaces.nextElement();
                if (!currentInterface.isUp() || currentInterface.isLoopback() || currentInterface.isVirtual()) continue;
                logger.trace("Current Inteface: {}", (Object)currentInterface.toString());
                Enumeration<InetAddress> addresses = currentInterface.getInetAddresses();
                while (!found && addresses.hasMoreElements()) {
                    InetAddress currentAddress = addresses.nextElement();
                    if (currentAddress.isLoopbackAddress()) continue;
                    if (currentAddress instanceof Inet4Address) {
                        ipv4 = currentAddress.getHostAddress();
                        logger.trace("IPv4 Address: {}", (Object)currentAddress.getHostAddress());
                    } else if (currentAddress instanceof Inet6Address) {
                        ipv6 = currentAddress.getHostAddress();
                        logger.trace("IPv6 Address: {}", (Object)currentAddress.getHostAddress());
                    }
                    if (ipv4 == null || ipv6 == null) continue;
                    found = Boolean.TRUE;
                }
            }
        }
        catch (SocketException ex) {
            logger.error("Failed to get IP Address, error: {}", (Object)ex.getMessage());
        }
        if (getIpv4) {
            return ipv4;
        }
        return ipv6;
    }

    public static Set<String> getIpAddressList() {
        HashSet ips = Sets.newHashSet();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            boolean found = Boolean.FALSE;
            while (!found && interfaces.hasMoreElements()) {
                NetworkInterface currentInterface = interfaces.nextElement();
                if (!currentInterface.isUp() || currentInterface.isLoopback() || currentInterface.isVirtual()) continue;
                Enumeration<InetAddress> addresses = currentInterface.getInetAddresses();
                while (!found && addresses.hasMoreElements()) {
                    String ip;
                    InetAddress currentAddress = addresses.nextElement();
                    if (currentAddress.isLoopbackAddress() || !(currentAddress instanceof Inet4Address) || Strings.isNullOrEmpty((String)(ip = currentAddress.getHostAddress()))) continue;
                    ips.add(ip);
                }
            }
        }
        catch (SocketException ex) {
            logger.error("Failed to get IP Address, error: {}", (Object)ex.getMessage());
        }
        return ips;
    }

    public static String getIpAddress(boolean getIpv4, String networkInterfaceName) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            boolean found = Boolean.FALSE;
            while (!found && interfaces.hasMoreElements()) {
                NetworkInterface currentInterface = interfaces.nextElement();
                if (!currentInterface.isUp() || currentInterface.isLoopback() || currentInterface.isVirtual() || !StringTools.eq(currentInterface.getDisplayName(), networkInterfaceName)) continue;
                logger.trace("Current Inteface: {}", (Object)currentInterface.toString());
                Enumeration<InetAddress> addresses = currentInterface.getInetAddresses();
                while (!found && addresses.hasMoreElements()) {
                    InetAddress currentAddress = addresses.nextElement();
                    if (currentAddress.isLoopbackAddress()) continue;
                    if (currentAddress instanceof Inet4Address && getIpv4) {
                        logger.trace("IPv4 Address: {}:{}", (Object)networkInterfaceName, (Object)currentAddress.getHostAddress());
                        return currentAddress.getHostAddress();
                    }
                    if (!(currentAddress instanceof Inet6Address & !getIpv4)) continue;
                    logger.trace("IPv6 Address: {}:{}", (Object)networkInterfaceName, (Object)currentAddress.getHostAddress());
                    return currentAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            logger.error("Failed to get IP Address, error: {}", (Object)ex.getMessage());
        }
        return "";
    }

    public static long currentThreadId() {
        return Thread.currentThread().getId();
    }

    public static String getHostnameMD5() {
        String host = SystemTools.getHostname();
        if (Strings.isNullOrEmpty((String)host)) {
            return "";
        }
        return Hashing.md5().hashString((CharSequence)host, Charset.forName("utf-8")).toString();
    }

    public static String getHostname() {
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            if (!Strings.isNullOrEmpty((String)hostname)) {
                return hostname;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostname = System.getenv("COMPUTERNAME");
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        hostname = System.getenv("HOSTNAME");
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        return null;
    }

    public static String getTmpDir() {
        return SystemTools.getTmpDir("");
    }

    public static String getTmpDir(String path) {
        int ret;
        if (!Strings.isNullOrEmpty((String)tmpDir)) {
            return tmpDir;
        }
        tmpDir = System.getProperty("java.io.tmpdir");
        if (Strings.isNullOrEmpty((String)tmpDir)) {
            tmpDir = "./tmp";
        }
        tmpDir = tmpDir.endsWith(File.separator) ? tmpDir + "gtt-vms" : tmpDir + File.separator + "gtt-vms";
        if (!Strings.isNullOrEmpty((String)path)) {
            tmpDir = tmpDir + File.separator + path;
        }
        if ((ret = SystemTools.mkdirIfAbsent(tmpDir)) == 0) {
            logger.info("mkdir:{} success", (Object)tmpDir);
        } else {
            logger.info("mkdir:{} failed", (Object)tmpDir);
        }
        return tmpDir;
    }

    public static int mkdirIfAbsent(String dir) {
        if (Strings.isNullOrEmpty((String)dir)) {
            return 1;
        }
        File folder = new File(dir);
        if (folder.exists() && folder.isDirectory()) {
            return 0;
        }
        if (folder.mkdirs()) {
            return 0;
        }
        return 1;
    }

    public static final int getCurrentPid() {
        String pid;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeMXBean.getName();
        if (processName.indexOf(64) != -1 && !Strings.isNullOrEmpty((String)(pid = processName.substring(0, processName.indexOf(64))))) {
            return Integer.valueOf(pid);
        }
        return -1;
    }

    public static void printEnvs() {
        SystemTools.printEnvs(null);
    }

    public static void printEnvs(String appdir) {
        if (Strings.isNullOrEmpty((String)appdir)) {
            appdir = "gtt-vms-tmp";
        }
        String tmpdir = SystemTools.getTmpDir(appdir);
        logger.info("******************************************************************************");
        logger.info("*IP             :{}", (Object)Joiner.on((String)",").skipNulls().join(SystemTools.getIpAddressList()));
        logger.info("*HOST           :{}({})", (Object)SystemTools.getHostname(), (Object)SystemTools.getHostnameMD5());
        logger.info("*TMP DIR        :{}", (Object)tmpdir);
        logger.info("*PID            :{}", (Object)SystemTools.getCurrentPid());
        logger.info("******************************************************************************");
    }

    public static String getenv(String key) {
        return System.getenv(key);
    }
}

