/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.filter.common;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class WebResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private int contentLength;
    private String contentType;

    public WebResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getData() {
        return this.output.toByteArray();
    }

    public ServletOutputStream getOutputStream() {
        return new FilterServletOutputStream(this, this.output);
    }

    public PrintWriter getWriter() {
        return new PrintWriter((OutputStream)this.getOutputStream(), true);
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }

    class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;
        private WriteListener writeListener;

        public FilterServletOutputStream(WebResponseWrapper this$0, OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return Boolean.TRUE;
        }

        public void setWriteListener(WriteListener wl) {
            this.writeListener = wl;
        }

        public WriteListener getWriteListener() {
            return this.writeListener;
        }
    }
}

