/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.filter.crypt.v2;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.exception.ApiException;
import tech.gtt.common.web.filter.crypt.v2.CryptFactory;
import tech.gtt.common.web.filter.crypt.v2.ICryptProvider;

public class CryptTools {
    private static final Logger logger = LoggerFactory.getLogger(CryptTools.class);

    public String decrypt(String protocol, String msg, String signature) throws ApiException {
        boolean isSignature;
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        if (!provider.isSupportCrypt()) {
            return msg;
        }
        if (provider.isSupportSignature() && !(isSignature = provider.checkSignature(msg, signature))) {
            throw new ApiException(-99911, "SIGNATURE_FAILED");
        }
        return provider.decrypt(msg);
    }

    public String encrypt(String protocol, String msg) throws ApiException {
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        if (!provider.isSupportCrypt()) {
            return msg;
        }
        return provider.encrypt(msg);
    }

    public String signature(String protocol, String msg) throws ApiException {
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        return provider.signature(msg);
    }
}

