/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.limiter;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterCacheTools {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterCacheTools.class);

    public static <K, V> Cache<K, V> createCache(final String cacheName, int timeUnitSeconds) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().recordStats().expireAfterAccess((long)timeUnitSeconds, TimeUnit.SECONDS).removalListener(new RemovalListener<K, V>(){

            public void onRemoval(RemovalNotification<K, V> n) {
                if (n.wasEvicted()) {
                    logger.info("[{}]Remove from cache[{}:{}]", new Object[]{cacheName, n.getKey(), n.getValue()});
                }
            }
        });
        logger.info("[{}]:{}", (Object)cacheName, (Object)cacheBuilder.toString());
        return cacheBuilder.build();
    }
}

