/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.filter.crypt.filter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import tech.gtt.common.base.JSON.JSONTools;
import tech.gtt.common.base.type.CollectionUtils;
import tech.gtt.common.web.filter.common.WebRequestWrapper;
import tech.gtt.common.web.filter.crypt.CryptMsgTools;

public class RequestCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(RequestCryptFilter.class);
    private Gson gson = new Gson();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String s;
        String m;
        WebRequestWrapper wrapper = new WebRequestWrapper(request);
        request.setAttribute("RequestArrivalTime", (Object)System.currentTimeMillis());
        String v = wrapper.getParameter("v");
        if (Strings.isNullOrEmpty((String)v)) {
            v = wrapper.getParameter("prot");
        }
        if (Strings.isNullOrEmpty((String)(m = wrapper.getParameter("m")))) {
            m = wrapper.getParameter("payload");
        }
        if (Strings.isNullOrEmpty((String)(s = wrapper.getParameter("s")))) {
            s = wrapper.getParameter("signature");
        }
        if (!Strings.isNullOrEmpty((String)v) && !Strings.isNullOrEmpty((String)m)) {
            try {
                String dm = CryptMsgTools.decryptMsg(v, m, s);
                Map<String, Object> decryptMap = JSONTools.fromJson2(dm, new TypeReference<Map<String, Object>>(this){});
                if (!CollectionUtils.isNullOrEmpty(decryptMap)) {
                    wrapper.addAllParameters(decryptMap);
                    wrapper.setOriginalBodyStr(dm);
                }
            }
            catch (Exception e) {
                logger.error(String.format("Bad request: Invalid request parameter. m=[%s], v=[%s]", m, v), (Throwable)e);
                throw new IllegalArgumentException("Bad request: Invalid request parameter");
            }
        }
        filterChain.doFilter((ServletRequest)wrapper, (ServletResponse)response);
    }

    public void destroy() {
    }
}

