/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.base.uniqueid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.uniqueid.TsidCreator;
import tech.gtt.common.base.uniqueid.TsidFactory;
import tech.gtt.common.base.uniqueid.Xid;

public class UniqueIdGenerate {
    private static final Logger logger = LoggerFactory.getLogger(UniqueIdGenerate.class);
    private static final UniqueIdGenerate instance = new UniqueIdGenerate();

    private UniqueIdGenerate() {
    }

    public static UniqueIdGenerate getInstance() {
        return instance;
    }

    public String getUniqueIdString() {
        return new Xid().toHexString();
    }

    public byte[] getUniqueIdByteArray() {
        return new Xid().toByteArray();
    }

    public Long getUniqueIdLong(String podIP) {
        if (podIP == null || podIP.isEmpty()) {
            logger.error("podIP is null or empty, use default method to generate unique id");
            return TsidCreator.getTsid().toLong();
        }
        String[] split = podIP.split("\\.");
        String lastTwo = split[2];
        String lastOne = split[3];
        String lastTwoBinary = String.format("%8s", Integer.toBinaryString(Integer.parseInt(lastTwo))).replace(' ', '0');
        String lastOneBinary = String.format("%8s", Integer.toBinaryString(Integer.parseInt(lastOne))).replace(' ', '0');
        String nodeBinary = lastTwoBinary + lastOneBinary;
        int nodeIdentifier = Integer.parseInt(nodeBinary, 2);
        return TsidFactory.newInstance65536(nodeIdentifier).create().toLong();
    }
}

