/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.config.file.monitor;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.config.file.monitor.FileNameFilter;
import tech.gtt.common.config.file.monitor.IFileChangeListener;

public class SingleFileMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileMonitor.class);
    private FileAlterationMonitor monitor;
    private long interval = 0L;
    private Map<String, FileAlterationObserver> directoryObserverMap = Maps.newLinkedHashMap();

    public SingleFileMonitor(long interval) {
        this.interval = interval;
        if (this.interval > 0L) {
            if (this.interval < 1000L) {
                this.interval = 1000L;
            }
            this.monitor = new FileAlterationMonitor(interval);
        } else {
            this.monitor = new FileAlterationMonitor(600000L);
        }
    }

    private void load(File fn, IFileChangeListener listener) {
        listener.onFileCreate(fn);
    }

    public SingleFileMonitor monitorFile(String fn, IFileChangeListener listener) {
        if (Strings.isNullOrEmpty((String)fn)) {
            return this;
        }
        String path = FilenameUtils.getFullPath((String)fn);
        String name = FilenameUtils.getName((String)fn);
        return this.monitorFile(path, name, listener);
    }

    public SingleFileMonitor monitorFile(String path, String fn, IFileChangeListener listener) {
        if (Strings.isNullOrEmpty((String)path) || Strings.isNullOrEmpty((String)fn)) {
            return this;
        }
        this.load(FileUtils.getFile((String[])new String[]{path, fn}), listener);
        if (this.interval > 0L) {
            String ext = FilenameUtils.getExtension((String)fn);
            String baseName = FilenameUtils.getName((String)fn);
            IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter((String)ext), new FileNameFilter(baseName)});
            FileAlterationObserver observer = new FileAlterationObserver(FileUtils.getFile((String[])new String[]{path}), (FileFilter)fileFilter);
            observer.addListener((FileAlterationListener)listener);
            this.monitor.addObserver(observer);
        }
        return this;
    }

    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            logger.info("Start exception:{}", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            logger.info("Stop exception:{}", (Throwable)e);
        }
    }
}

