/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.common.web.servicetoken;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.web.servicetoken.EService;

public class ServiceToken4FactoryV2 {
    private static final Logger logger = LoggerFactory.getLogger(ServiceToken4FactoryV2.class);

    public static String buildSTV2(String mac, String activeCode) {
        String stStr = mac.toUpperCase() + activeCode;
        String md5 = Hashing.md5().hashString((CharSequence)stStr, Charsets.UTF_8).toString().toLowerCase();
        return md5.substring(8, 24);
    }

    public static String getSTByService(EService service, String st) {
        if (Strings.isNullOrEmpty((String)st)) {
            logger.warn("ST is empty!");
            return "";
        }
        if (st.length() != 32) {
            logger.warn("ST[{}] Wrong length", (Object)st);
            return "";
        }
        if (service == EService.LIVE) {
            return st.substring(0, 16);
        }
        return st.substring(16, 32);
    }

    public static String checkST(EService service, String st, String mac, String activeCode) {
        String st4Service = ServiceToken4FactoryV2.getSTByService(service, st);
        if (Strings.isNullOrEmpty((String)st4Service)) {
            logger.error("ST[{}] Service[{}] mac[{}] activeCode[{}] Cannot found Service ST", new Object[]{st, service, mac, activeCode});
            return "";
        }
        String original = ServiceToken4FactoryV2.buildSTV2(mac, activeCode);
        if (original.contentEquals(st4Service)) {
            return st4Service;
        }
        logger.error("ST[{}] Service[{}] mac[{}] activeCode[{}] ST check failed", new Object[]{st, service, mac, activeCode});
        return "";
    }
}

