/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.euser.live.tokenvalidator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.euser.live.tokenvalidator.ITokenValidator;
import tech.gtt.euser.live.tokenvalidator.annotation.TokenValidator;
import tech.gtt.euser.live.tokenvalidator.bean.EndUserTokenValidateResult;
import tech.gtt.euser.live.tokenvalidator.bean.ValidatorCheckResultEndUser;
import tech.gtt.euser.live.tokenvalidator.enums.ValidateResultStatusCodeEnum;
import tech.gtt.euser.live.tokenvalidator.tool.Validator;

public class EndUserTokenValidator {
    private static final Logger logger = LoggerFactory.getLogger(EndUserTokenValidator.class);
    private static EndUserTokenValidator singleInstance = new EndUserTokenValidator();
    private static final String TOKEN_VALIDATOR_SCAN_PACKAGE = "tech.gtt.euser.live.tools.tokenvalidator.validatorimpl";
    private List<ITokenValidator> tokenValidatorList;

    public static EndUserTokenValidator getInstance() {
        return singleInstance;
    }

    private EndUserTokenValidator() {
        try {
            this.init();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("euser tokenValidator init failed", (Throwable)e);
        }
    }

    public EndUserTokenValidateResult checkToken(String token, String mac, String loginId) {
        if (Validator.isNullOrEmpty(token)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        if (Validator.isNullOrEmpty(mac) && Validator.isNullOrEmpty(loginId)) {
            throw new IllegalArgumentException("both mac and loginId are null or empty");
        }
        ValidatorCheckResultEndUser result = null;
        for (ITokenValidator tokenValidator : this.tokenValidatorList) {
            result = tokenValidator.checkToken(token, mac, loginId);
            if (result.isTokenIllegal()) continue;
            return result;
        }
        throw new IllegalArgumentException("token isn't parsable");
    }

    private void init() throws InstantiationException, IllegalAccessException {
        this.tokenValidatorList = new ArrayList<ITokenValidator>();
        Reflections f = new Reflections(TOKEN_VALIDATOR_SCAN_PACKAGE, new Scanner[0]);
        Set set = f.getTypesAnnotatedWith(TokenValidator.class);
        List<Class> orderedList = this.sortTokenValidatorClass(set);
        for (Class tokenValidatorClass : orderedList) {
            this.tokenValidatorList.add((ITokenValidator)tokenValidatorClass.newInstance());
        }
    }

    private List<Class> sortTokenValidatorClass(Set<Class<?>> set) {
        ArrayList<Class> list = new ArrayList<Class>(set);
        Collections.sort(list, new Comparator<Class>(this){

            @Override
            public int compare(Class o1, Class o2) {
                TokenValidator anno1 = o1.getAnnotation(TokenValidator.class);
                TokenValidator anno2 = o2.getAnnotation(TokenValidator.class);
                return Integer.compare(anno1.order(), anno2.order());
            }
        });
        return list;
    }

    public static void main(String[] args) {
        String mac = System.getProperty("mac");
        String loginId = System.getProperty("loginId");
        String token = System.getProperty("token");
        try {
            EndUserTokenValidateResult result = EndUserTokenValidator.getInstance().checkToken(token, mac, loginId);
            if (result.getStatusCode() == ValidateResultStatusCodeEnum.VALID.getStatusCode()) {
                System.out.println("token is valid");
            } else {
                System.out.println("token is invalid");
            }
            System.out.println(String.format("token validate result: statusCode=%s, statusDescription=%s, expiredTime=%s", result.getStatusCode(), result.getStatusDescription(), result.getExpiredTime()));
        }
        catch (IllegalArgumentException e) {
            System.out.println(String.format("api argument is illegal: %s", e.getMessage()));
        }
    }
}

