/*
 * Decompiled with CFR 0.152.
 */
package tech.gtt.euser.live.tokenvalidator.validatorimpl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.gtt.common.base.exception.ApiException;
import tech.gtt.euser.live.tokenvalidator.ITokenValidator;
import tech.gtt.euser.live.tokenvalidator.annotation.TokenValidator;
import tech.gtt.euser.live.tokenvalidator.bean.AuthToken;
import tech.gtt.euser.live.tokenvalidator.bean.ValidatorCheckResultEndUser;
import tech.gtt.euser.live.tokenvalidator.enums.ValidateResultStatusCodeEnum;
import tech.gtt.euser.live.tokenvalidator.tool.AESSecurity;
import tech.gtt.euser.live.tokenvalidator.tool.Base64;

@TokenValidator(order=200)
public class TokenValidatorFor2x
implements ITokenValidator {
    private static final Logger logger = LoggerFactory.getLogger(TokenValidatorFor2x.class);
    private static final String AUTH_TOKEN_KEY = "aJhsuTA1JKyM4H9ShRD7lA==";
    private static final byte[] AES_CBD_IV = "Ra@domI!itVe#to$".getBytes();

    @Override
    public ValidatorCheckResultEndUser checkToken(String token, String mac, String loginId) {
        AuthToken authToken;
        ValidatorCheckResultEndUser checkResult = new ValidatorCheckResultEndUser();
        try {
            authToken = this.parseAccountToken(token);
        }
        catch (Exception e) {
            logger.error(String.format("[enduser-token-validator] Error in Parse 2.x Token:[%s]", token), (Throwable)e);
            checkResult.setTokenIllegal(true);
            return checkResult;
        }
        if (authToken.getVersion() == 20170101 && !StringUtils.equals((CharSequence)authToken.getDid(), (CharSequence)mac)) {
            logger.error("[enduser-token-validator]token(2.x) is invalid: mac is mismatched, mac={} tokenMac={} token={}", new Object[]{mac, authToken.getDid(), token});
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.MAC_MISMATCH.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.MAC_MISMATCH.getStatusDescription());
            return checkResult;
        }
        if (authToken.getVersion() == 20171216 && !StringUtils.equals((CharSequence)authToken.getLoginId(), (CharSequence)loginId)) {
            logger.error("[enduser-token-validator]token(2.x) is invalid: loginId is mismatched, loginId={} tokenLoginId={} token={}", new Object[]{loginId, authToken.getLoginId(), token});
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.LOGINID_MISMATCH.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.LOGINID_MISMATCH.getStatusDescription());
            return checkResult;
        }
        long tokenExpiredTime = authToken.getEt();
        if (System.currentTimeMillis() > tokenExpiredTime) {
            logger.error("[enduser-token-validator]token(2.x) is invalid: account token is expired, tokenExpiredTime={} token={}", (Object)tokenExpiredTime, (Object)token);
            checkResult.setStatusCode(ValidateResultStatusCodeEnum.EXPIRED.getStatusCode());
            checkResult.setStatusDescription(ValidateResultStatusCodeEnum.EXPIRED.getStatusDescription());
            return checkResult;
        }
        checkResult.setStatusCode(ValidateResultStatusCodeEnum.VALID.getStatusCode());
        checkResult.setStatusDescription(ValidateResultStatusCodeEnum.VALID.getStatusDescription());
        checkResult.setExpiredTime(tokenExpiredTime);
        checkResult.setDid(authToken.getDid());
        checkResult.setAccountId(authToken.getAccountId());
        return checkResult;
    }

    private AuthToken parseAccountToken(String token) throws ApiException, JSONException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        byte[] bytesToken = Base64.decode(token, 10);
        byte[] decryptedBytesToken = AESSecurity.decrypt(bytesToken, Base64.decode(AUTH_TOKEN_KEY, 2), AES_CBD_IV);
        if (decryptedBytesToken == null) {
            return null;
        }
        JSONObject jsonToken = new JSONObject(new String(decryptedBytesToken));
        String did = jsonToken.getString("did");
        String g = null;
        String p = null;
        if (jsonToken.has("g")) {
            g = jsonToken.getString("g");
        }
        if (jsonToken.has("p")) {
            p = jsonToken.getString("p");
        }
        long ct = jsonToken.getLong("ct");
        long et = jsonToken.getLong("et");
        AuthToken authToken = new AuthToken();
        authToken.setDid(did);
        authToken.setG(g);
        authToken.setP(p);
        authToken.setCt(ct);
        authToken.setEt(et);
        if (jsonToken.has("clientId")) {
            authToken.setClientId(jsonToken.getLong("clientId"));
        }
        if (jsonToken.has("clientSession")) {
            authToken.setClientSession(jsonToken.getString("clientSession"));
        } else {
            authToken.setClientSession("");
        }
        if (jsonToken.has("loginId")) {
            authToken.setLoginId(jsonToken.getString("loginId"));
        } else {
            authToken.setLoginId("");
        }
        if (jsonToken.has("duid")) {
            authToken.setDuid(jsonToken.getString("duid"));
        } else {
            authToken.setDuid("");
        }
        long sessionStr = 0L;
        if (jsonToken.has("sessionStr")) {
            sessionStr = jsonToken.getLong("sessionStr");
        }
        long accountId = 0L;
        if (jsonToken.has("accountId")) {
            accountId = jsonToken.getLong("accountId");
        }
        String onlineLimit = null;
        if (jsonToken.has("onlineLimit")) {
            onlineLimit = jsonToken.getString("onlineLimit");
        }
        String clientType = null;
        if (jsonToken.has("clientType")) {
            clientType = jsonToken.getString("clientType");
        }
        String releaseId = null;
        if (jsonToken.has("releaseId")) {
            releaseId = jsonToken.getString("releaseId");
        }
        String appId = null;
        if (jsonToken.has("appId")) {
            appId = jsonToken.getString("appId");
        }
        String model = null;
        if (jsonToken.has("model")) {
            model = jsonToken.getString("model");
        }
        String deviceId = null;
        if (jsonToken.has("deid")) {
            deviceId = jsonToken.getString("deid");
        }
        String limitCount = null;
        if (jsonToken.has("lc")) {
            limitCount = jsonToken.getString("lc");
        }
        authToken.setVersion(jsonToken.getInt("v"));
        authToken.setServiceExpire(jsonToken.getLong("se"));
        authToken.setProperties(jsonToken.getLong("properties"));
        authToken.setLoginMethod(jsonToken.getInt("loginMethod"));
        authToken.setSessionStr(sessionStr);
        authToken.setAccountId(accountId);
        authToken.setOnlineLimit(onlineLimit);
        authToken.setClientType(clientType);
        authToken.setReleaseId(releaseId);
        authToken.setAppId(appId);
        authToken.setModel(model);
        authToken.setLimitCount(limitCount);
        authToken.setDeviceId(deviceId);
        return authToken;
    }
}

